#ifndef BOXWIDGET_H
#define BOXWIDGET_H

#include <QGraphicsWidget>
#include <QStateMachine>

class BoxWidget : public QGraphicsWidget
{
    Q_OBJECT
    Q_PROPERTY(QPointF pos READ pos WRITE setPos)
    Q_PROPERTY(qreal opacity READ opacity WRITE setOpacity)
    Q_PROPERTY(bool clickable READ isClickable WRITE setClickable)
    Q_PROPERTY(bool boxtile READ isBoxTile WRITE setBoxTile)
//    Q_PROPERTY(QColor color READ iColor WRITE setIColor)
    Q_PROPERTY(int color READ iColor WRITE setIColor)
    Q_PROPERTY(bool waytile READ isWayTile WRITE setWayTile)

//protected:
    friend QDataStream &operator<<(QDataStream &, const BoxWidget *);
    friend QDataStream &operator>>(QDataStream &, BoxWidget *);

public:
//    BoxWidget(QColor aColor = Qt::white, QGraphicsItem *parent = 0);
    BoxWidget(int aColor = 0, QGraphicsItem *parent = 0);
    QRectF boundingRect() const;
    QPainterPath shape() const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *);
    void setWayTile(bool aWay);
    void setClickable(bool aClickable);
    void setBoxTile(bool aBox);
//    void setColor(QColor aColor);
    void setIColor(int aColor);
    bool isWayTile();
    bool isClickable();
    bool isBoxTile();
//    QColor color();
    int iColor();
    void setStateBox(QState *aState);
    void setStateBack(QState *aState);
    void setStateWay(QState *aState);
    QState *stateBox();
    QState *stateBack();
    QState *stateWay();
    void setColorNumber(int aColorNumber);

    void setTransition(QAbstractTransition *aTrans, int aType, int aState);
    void setPoint(QPointF aPoint);
    QPointF point();

signals:
    void pressed();
//    void fired(QPointF, QPointF, QColor);
    void fired(QPointF, QPointF, int);

public slots:
    void transitionFinished();
    void transitionFinished1();
    void transitionFinished2();
    void transitionFinished3();

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *);

private:
    int checkCurrentState();

private:
//    QColor m_color;
    int m_color;
    bool m_clickable; // true - can be moved (start position with way enabled)
    bool m_wayTile; // true - way backround, false - simple backround
    bool m_boxTile; // true - active Box object, false - background tile
    QState *m_stateBox;
    QState *m_stateBack;
    QState *m_stateWay;
    QAbstractTransition *m_trans; //2box;
    QPointF m_point;
    int m_sourceState; // 0 - no trans, 1 - from way, 2 - from box, 3 - from tile
    int m_targetState; // 1 - way, 2 - box, 3 - tile
    int m_currentState; // 1 - way, 2 - box, 3 - tile
    int m_colorNumber;
    QPixmap m_pix;
    QPixmap m_bgPix;
};

QDataStream &operator<<(QDataStream &out, const BoxWidget *aBox);
QDataStream &operator>>(QDataStream &in, BoxWidget *aBox);

#endif // BOXWIDGET_H




