#ifndef MAEKERSTARTVIEW_H
#define MAEKERSTARTVIEW_H

#include <QGraphicsView>

class gameScene;
class menuScene;
class AboutScene;

class MaekerStartView : public QGraphicsView
{
    Q_OBJECT
public:
    MaekerStartView(QGraphicsScene *scene);

signals:
    void checkMenuState();

public slots:
    void newGame();
    void showMenu();
    void loadGame();
    void showAbout();
    void gameOver();
    void closeAbout();

//private:
  //  void sceneInit();

protected:
    void resizeEvent(QResizeEvent *event);

private:
    gameScene * m_gameScene;
    menuScene * m_menuScene;
    AboutScene * m_aboutScene;
    bool m_gameStarted;

};

#endif // MAEKERSTARTVIEW_H
