#ifndef MAEKERBUTTON_H
#define MAEKERBUTTON_H

#include <QGraphicsWidget>

class MaekerButton : public QGraphicsWidget
{
    Q_OBJECT
public:
    explicit MaekerButton(const QPixmap &pixmap,QGraphicsItem *parent = 0);
    QRectF boundingRect() const;
    QPainterPath shape() const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *);
    int width();
    int height();

signals:
    void clicked();

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *);

private:
    void toGray();

private:
    QPixmap _pix;
    QPixmap _pixGray;
};

#endif // MAEKERBUTTON_H
