#include <QPainter>
#include "digitwidget.h"

#define DIG_WIDTH 23
#define DIG_COUNT 9
#define WIDTH DIG_WIDTH*DIG_COUNT
//#define FWIDTH = 100
#define HEIGHT 25

DigitWidget::DigitWidget(QGraphicsItem *parent) :
    QGraphicsWidget(parent)
{
    setCacheMode(DeviceCoordinateCache);
    _number = 0;
    _digCol = 1;
}

/*int DigitWidget::getWidth() const
{
    return _width;
}*/

QRectF DigitWidget::boundingRect() const
{
//    return QRectF(-WIDTH/2, -HEIGHT/2, WIDTH, HEIGHT);
    return QRectF(-_width/2, -HEIGHT/2, _width, HEIGHT);
}

QPainterPath DigitWidget::shape() const
{
    QPainterPath path;
    path.addRect(boundingRect());
    return path;
}

void DigitWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{
    int tNumber = _number;
    int digPos = 1;
    int wd = _width/2;
    int hg = HEIGHT/2;

    if (tNumber == 0)
    {
        QPixmap px(QString(":/img/0.png"));
        painter->drawPixmap(wd - DIG_WIDTH*digPos, -hg, px);
    }

    while (tNumber > 0)
    {
        int tDigit = tNumber%10;
        QPixmap px(QString(":/img/%1.png").arg(QString::number(tDigit)));
        painter->drawPixmap(wd - DIG_WIDTH*digPos, -hg, px);
        tNumber /= 10;
        if ((digPos == 3) || (digPos == 7))
            digPos++;
        digPos++;
    }
/*    bool down = option->state & QStyle::State_Sunken;
    if (!this->isEnabled())
//        painter->drawPixmap(-_pix.width()/2, -_pix.height()/2, _pixGray); //TODO temp disabled for black pics
        painter->drawPixmap(-_pix.width()/2, -_pix.height()/2, _pix);
    else if (down)
        painter->drawPixmap(-_pix.width()/2+2, -_pix.height()/2+2, _pix.scaledToWidth(_pix.width()-4));
    else
        painter->drawPixmap(-_pix.width()/2, -_pix.height()/2, _pix);*/
}

void DigitWidget::setNumber(int aNumber)
{
    _number = aNumber;
    while (_number > 10000000)
        _number /= 10;

    int tNumber = _number;
    int colNum = 0;
    while (tNumber > 0)
    {
        tNumber /= 10;
        if ((colNum == 3) || (colNum == 7))
            colNum++;
        colNum++;
    }
    if (colNum == 0)
        colNum++;
    _width = colNum*DIG_WIDTH;
    update();
}

int DigitWidget::number()
{
    return _number;
}
