#include <QPainter>
#include <QtGui>
#include "boxwidget.h"

#define NUM_COLORS 7

BoxWidget::BoxWidget(int aColor, QGraphicsItem *parent)  //(const QPixmap &pixmap, QGraphicsItem *parent = 0)
    : QGraphicsWidget(parent)//, m_color(aColor) //, _pix(pixmap)
{
//        setAcceptHoverEvents(true);
    setCacheMode(DeviceCoordinateCache);
    m_clickable = false;
    m_boxTile = false;
    m_wayTile = false;
    m_sourceState = 0;
    m_targetState = 3;
    m_colorNumber = 5;
    setIColor(aColor);
    m_bgPix = QPixmap(QString(":/img/box10.png"));
}

QRectF BoxWidget::boundingRect() const
{
    return QRectF(-20, -20, 40, 40);
}

QPainterPath BoxWidget::shape() const
{
    QPainterPath path;
    path.addRect(boundingRect());
    return path;
}

void BoxWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{
//    bool down = option->state & QStyle::State_Sunken;
    QRectF r = boundingRect();
/*    QLinearGradient grad(r.topLeft(), r.bottomRight());
    grad.setColorAt(0, Qt::white);
    grad.setColorAt(1, m_color);*/
    QBrush aa;
    painter->setOpacity(opacity());
//    painter->setPen(m_color);

//    painter->setPen(Qt::darkGray);
    if (m_boxTile)
    {
      //  painter->setPen(m_color);
        painter->drawPixmap(-20,-20,m_pix);
//        painter->setBrush(grad);
//        painter->setBrush(m_brush);
    }
    else if (!m_wayTile)
    {
//        painter->setPen(Qt::white);
        painter->drawPixmap(-20,-20,m_bgPix);
/*        aa.setStyle(Qt::DiagCrossPattern);
        aa.setColor(Qt::darkGray);
        painter->setBrush(aa);
        painter->drawRect(r);*/
    }
    else
    {
  //      painter->setPen(m_color);
        aa.setStyle(Qt::DiagCrossPattern);
        aa.setColor(Qt::lightGray);
        painter->setBrush(aa);
        painter->drawRect(r);
//        painter->setOpacity(opacity());

    }
//    painter->drawRect(r);
}


void BoxWidget::mousePressEvent(QGraphicsSceneMouseEvent *)
{
    if (m_clickable && m_boxTile)
    {
        emit pressed();
//        QPointF aa = m_state->property("pos").toPointF();
        emit fired(pos(), m_point, m_color);
    }
    update();
}

void BoxWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent *)
{
  //  emit pressed();
    update();
}

void BoxWidget::setWayTile(bool aWay)
{
    m_wayTile = aWay;
}

void BoxWidget::setClickable(bool aClickable)
{
    m_clickable = aClickable;
}

void BoxWidget::setBoxTile(bool aBox)
{
    m_boxTile = aBox;
}

//void BoxWidget::setColor(QColor aColor)
void BoxWidget::setIColor(int aColor)
{
//    if (aColor == Qt::transparent)
//    if (!isWayTile() && !isBoxTile())

//    else
  //  {
        if (!aColor)
            m_color = qrand() % m_colorNumber + 1;
        else
            m_color = aColor;

        m_pix = QPixmap(QString(":/img/box%1.png").arg(QString::number(m_color)));
//    }
    update();
}

bool BoxWidget::isWayTile()
{
    return m_wayTile;
}

bool BoxWidget::isClickable()
{
    return m_clickable;
}

bool BoxWidget::isBoxTile()
{
    return m_boxTile;
}

//QColor BoxWidget::color()
int BoxWidget::iColor()
{
    return m_color;
}

void BoxWidget::setStateBox(QState *aState)
{
    m_stateBox = aState;
}

void BoxWidget::setStateBack(QState *aState)
{
    m_stateBack = aState;
}

void BoxWidget::setStateWay(QState *aState)
{
    m_stateWay = aState;
}

void BoxWidget::setTransition(QAbstractTransition *aTrans, int aType, int aState)
{
    switch (m_sourceState)
    {
    case 0:
        break;
    case 1:
        m_stateWay->removeTransition(m_trans);
        break;
    case 2:
        m_stateBox->removeTransition(m_trans);
        break;
    case 3:
        m_stateBack->removeTransition(m_trans);
        break;

    default:
        break;
    }
    m_trans = aTrans;
    m_sourceState = aType;
    m_targetState = aState;
//    m_stateBox->addTransition(aTrans);
}

/*void BoxWidget::setTransitionBack(QAbstractTransition *aTrans)
{
    m_trans = aTrans;
    m_stateBack->addTransition(aTrans);
}
*/
/*void BoxWidget::setTransitionNull()
{
    m_stateBox->removeTransition(m_trans);
    m_stateBack->removeTransition(m_trans);
}*/


void BoxWidget::setPoint(QPointF aPoint)
{
    m_point = aPoint;
}


QPointF BoxWidget::point()
{
    return m_point;
}

/*void BoxWidget::setBrush(QBrush aBrush)
{
    m_brush = aBrush;
}

QBrush BoxWidget::brush()
{
    return m_brush;
}*/
int BoxWidget::checkCurrentState()
{
    if (isBoxTile())
        return 2;
    else if (isWayTile())
        return 1;
    else return 3;
}

void BoxWidget::transitionFinished()
{
    switch (m_sourceState)
    {
    case 1:
        if (m_currentState == m_targetState)
            m_stateWay->removeTransition(m_trans);
        break;
    case 2:
        if (m_currentState == m_targetState)
            m_stateBox->removeTransition(m_trans);
        break;
    case 3:
        if (m_currentState == m_targetState)
            m_stateBack->removeTransition(m_trans);
        break;
    default:
        break;
    }
    m_sourceState = 0;
}

void BoxWidget::transitionFinished1()
{
    m_currentState = 3;
    m_wayTile = false;
    m_boxTile = false;
    setOpacity(1);
    m_color = Qt::white;
//    transitionFinished();
    update();
    //if ((!m_wayTile) && (!m_boxTile))
      //  m_stateBox->removeTransition(m_trans);
    //m_trans = new QAbstractTransition();
//    if (m_trans)
  //      delete m_trans;
}

void BoxWidget::transitionFinished2()
{
    m_currentState = 2;
    m_wayTile = false;
    m_boxTile = true;
  //  transitionFinished();
    update();
//    if (!m_wayTile)
  //      m_stateWay->removeTransition(m_trans);
    //m_trans = new QAbstractTransition();
//    if (m_trans)
  //      delete m_trans;
}

void BoxWidget::transitionFinished3()
{
    m_currentState = 1;
    m_wayTile = true;
    m_boxTile = false;
    m_color = Qt::white;
    setOpacity(0);
    //transitionFinished();
    update();
    //if(m_wayTile)
      //  m_stateBack->removeTransition(m_trans);
    //m_trans = new QAbstractTransition();
//    if (m_trans)
  //      delete m_trans;
}

/*void BoxWidget::transitionFinishedWay2Back()
{
    m_stateWay->removeTransition(m_trans);
}*/

QState *BoxWidget::stateBox()
{   return m_stateBox; }

QState *BoxWidget::stateBack()
{   return m_stateBack; }

QState *BoxWidget::stateWay()
{   return m_stateWay; }

void BoxWidget::setColorNumber(int aColorNumber)
{
    m_colorNumber = aColorNumber;
}

QDataStream &operator<<(QDataStream &out, const BoxWidget *aBox)
{
  out << aBox->m_color;
  out << aBox->m_boxTile;
  out << aBox->m_colorNumber;
  out << aBox->m_wayTile;
  return out;
}

QDataStream &operator>>(QDataStream &in, BoxWidget *aBox)
{
  int clr;
  in >> clr;
  aBox->setIColor(clr);
  in >> aBox->m_boxTile;
  in >> aBox->m_colorNumber;
  in >> aBox->m_wayTile;
  return in;
}
