#include <QPainter>
#include <QStyleOptionGraphicsItem>
#include "maekerbutton.h"

MaekerButton::MaekerButton(const QPixmap &pixmap,QGraphicsItem *parent) :
    QGraphicsWidget(parent), _pix(pixmap)
{
//    setAcceptHoverEvents(true);
    setCacheMode(DeviceCoordinateCache);
    toGray();
}

QRectF MaekerButton::boundingRect() const
{
    return QRectF(-_pix.width()/2, -_pix.height()/2, _pix.width()+2, _pix.height()+2);
}

QPainterPath MaekerButton::shape() const
{
    QPainterPath path;
    path.addRect(boundingRect());
    return path;
}


void MaekerButton::toGray()
{
    QImage image = _pix.toImage();
    QRgb col;
    int gray;
    for (int i = 0; i < _pix.width(); ++i)
    {
        for (int j = 0; j < _pix.height(); ++j)
        {
            col = image.pixel(i, j);
            gray = qGray(col);
            image.setPixel(i, j, qRgb(gray, gray, gray));
        }}
    _pixGray = QPixmap::fromImage(image);
}

void MaekerButton::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *)
{
//    bool down = option->state & QStyle::State_Sunken;
//    QRectF r = boundingRect();
/*    QLinearGradient grad(r.topLeft(), r.bottomRight());
    grad.setColorAt(down ? 1 : 0, option->state & QStyle::State_MouseOver ? Qt::white : Qt::lightGray);
    grad.setColorAt(down ? 0 : 1, Qt::darkGray);
    painter->setPen(Qt::darkGray);
    painter->setBrush(grad);
    painter->drawEllipse(r);
    QLinearGradient grad2(r.topLeft(), r.bottomRight());
    grad.setColorAt(down ? 1 : 0, Qt::darkGray);
    grad.setColorAt(down ? 0 : 1, Qt::lightGray);
    painter->setPen(Qt::NoPen);
    painter->setBrush(grad);
    if (down)
        painter->translate(2, 2);
    painter->drawEllipse(r.adjusted(5, 5, -5, -5));*/

    bool down = option->state & QStyle::State_Sunken;
    if (!this->isEnabled())
//        painter->drawPixmap(-_pix.width()/2, -_pix.height()/2, _pixGray); //TODO temp disabled for black pics
        painter->drawPixmap(-_pix.width()/2, -_pix.height()/2, _pix);
    else if (down)
        painter->drawPixmap(-_pix.width()/2+2, -_pix.height()/2+2, _pix.scaledToWidth(_pix.width()-4));
    else
        painter->drawPixmap(-_pix.width()/2, -_pix.height()/2, _pix);
}

void MaekerButton::mousePressEvent(QGraphicsSceneMouseEvent *)
{
//    emit clicked();
    update();
}

void MaekerButton::mouseReleaseEvent(QGraphicsSceneMouseEvent *)
{
    emit clicked();
    update();
}

int MaekerButton::width()
{
    return _pix.width();
}

int MaekerButton::height()
{
    return _pix.height();
}
