#include <QtGui>
#include <QtDBus/QtDBus>
#include "menuscene.h"
#include "maekerstartview.h"
#include "maekerbutton.h"

#define STATE_FILE "gamestate.dat"
#if defined(Q_WS_MAEMO_5)
    #define CFG_DIR "/home/user/.skidstone/"
#else
    #define CFG_DIR ""
#endif

menuScene::menuScene(QObject *parent) :
    QGraphicsScene(parent)
{
    this->setSceneRect(-400, -240, 800, 480);

    QPixmap bgPix(":/img/menu_back.png");
    QGraphicsItem *item = this->addPixmap(bgPix);
    item->setPos(-400,-240);
    sceneInit();
}

void menuScene::sceneInit()
{
#if defined(Q_WS_MAEMO_5)
    QDir dir(CFG_DIR);
    if (!dir.exists())
    {
        dir.mkpath(CFG_DIR);
    }
#endif

    QPixmap buttonPix1(":/img/new_game.png");
    MaekerButton * mb = new MaekerButton(buttonPix1);
    this->addItem(mb);
    mb->setPos(155,-70);
    connect(mb,SIGNAL(clicked()),this,SLOT(newGame()));

    QPixmap buttonPix(":/img/continue.png");
    m_contButton = new MaekerButton(buttonPix);
    this->addItem(m_contButton);
    m_contButton->setPos(155,5);
    connect(m_contButton,SIGNAL(clicked()),this,SLOT(loadGame()));
    checkState();

    QPixmap buttonPix4(":/img/yes.png");
    m_yesButton = new MaekerButton(buttonPix4);
    this->addItem(m_yesButton);
    m_yesButton->setPos(105,5);
    m_yesButton->setEnabled(false);
    m_yesButton->setVisible(false);
    connect(m_yesButton,SIGNAL(clicked()),this,SLOT(yesNewGame()));

    QPixmap buttonPix5(":/img/no.png");
    m_noButton = new MaekerButton(buttonPix5);
    this->addItem(m_noButton);
    m_noButton->setPos(205,5);
    m_noButton->setEnabled(false);
    m_noButton->setVisible(false);
    connect(m_noButton,SIGNAL(clicked()),this,SLOT(noNewGame()));

    /*    //no scores yet
aa = new QPushButton("Scores");
    pw = this->addWidget(aa);
    pw->setPos(-20,-50);
    connect(aa,SIGNAL(clicked()),this,SLOT(scoresShow()));*/

    QPixmap buttonPix2(":/img/about.png");
    mb = new MaekerButton(buttonPix2);
    this->addItem(mb);
    mb->setPos(155,80);
    connect(mb,SIGNAL(clicked()),this,SLOT(showAbout()));

    QPixmap buttonPix3(":/img/exit.png");
    mb = new MaekerButton(buttonPix3);
    this->addItem(mb);
    mb->setPos(155,180);
    connect(mb,SIGNAL(clicked()),this,SLOT(exitGame()));

/*  //TODO make cross button
    QPixmap buttonPix(":/img/back.png");
    mb = new MaekerButton(buttonPix);
    this->addItem(mb);
    mb->setPos(360,-210);
    connect(mb,SIGNAL(clicked()),this,SLOT(exitGame()));
*/


#if defined(Q_WS_MAEMO_5)
    QPixmap buttonPix6(":/img/desk.png");
    mb = new MaekerButton(buttonPix6);
    this->addItem(mb);
    mb->setPos(-368,-211);
    connect(mb,SIGNAL(clicked()),this,SLOT(gotoDektop()));
#endif
}

void menuScene::showAbout()
{
    emit aboutPopup();
}

// minimize application
void menuScene::gotoDektop()
{
#if defined(Q_WS_MAEMO_5)
    QDBusConnection c = QDBusConnection::sessionBus();
    QDBusMessage m = QDBusMessage::createSignal("/","com.nokia.hildon_desktop","exit_app_view");
    c.send(m);
#endif
}

void menuScene::newGame()
{
    //TODO check for current game
    if (m_contButton->isEnabled())
    {
        m_yesButton->setEnabled(true);
        m_yesButton->setVisible(true);
        m_noButton->setEnabled(true);
        m_noButton->setVisible(true);
        m_contButton->setEnabled(false);
        m_contButton->setVisible(false);
    }
    else
        yesNewGame();
}

void menuScene::yesNewGame()
{
    m_yesButton->setEnabled(false);
    m_yesButton->setVisible(false);
    m_noButton->setEnabled(false);
    m_noButton->setVisible(false);
    m_contButton->setEnabled(true);
    m_contButton->setVisible(true);
    emit newGameClicked();
}

void menuScene::noNewGame()
{
    m_yesButton->setEnabled(false);
    m_yesButton->setVisible(false);
    m_noButton->setEnabled(false);
    m_noButton->setVisible(false);
    m_contButton->setEnabled(true);
    m_contButton->setVisible(true);
}

void menuScene::scoresShow()
{
    emit scoresClicked();
}

void menuScene::exitGame()
{
    qApp->quit();
}

void menuScene::loadGame()
{
    emit loadGameClicked();
}

void menuScene::checkState()
{
    QString fname = QString(CFG_DIR) + QString(STATE_FILE);
    QFile file(fname);
    if (file.exists())
    {
        m_contButton->setEnabled(true);
        m_contButton->setOpacity(1);
    }
    else
    {
        m_contButton->setEnabled(false);
        m_contButton->setOpacity(0.5);
    }
}
