/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/


#include <QtCore/QString>
#include <QtTest/QtTest>

#include "coordinates/geocoordinate.h"
#include "routing/routesegment.h"

#include "routing/route.h"

class TestRoute : public QObject
{
    Q_OBJECT

private Q_SLOTS:
    void geometryPoints();
    void segments();
    void settersAndGetters();
};

void TestRoute::geometryPoints()
{
    // test points
    GeoCoordinate point1(12.3456, 54.3210);
    GeoCoordinate point2(65.5000, 25.0000);
    GeoCoordinate point3(-23.4567, 43.0987);

    // create route with points
    Route route;
    route.appendGeometryPoint(point1);
    route.appendGeometryPoint(point2);
    route.appendGeometryPoint(point3);

    // test points
    const QList<GeoCoordinate> &points = route.geometryPoints();
    QVERIFY(points.count() == 3);

    QCOMPARE(points.at(0).latitude(), point1.latitude());
    QCOMPARE(points.at(0).longitude(), point1.longitude());

    QCOMPARE(points.at(1).latitude(), point2.latitude());
    QCOMPARE(points.at(1).longitude(), point2.longitude());

    QCOMPARE(points.at(2).latitude(), point3.latitude());
    QCOMPARE(points.at(2).longitude(), point3.longitude());
}

void TestRoute::segments()
{
    // test segments
    RouteSegment segment1;
    RouteSegment segment2;
    RouteSegment segment3;
    segment1.setPositionIndex(11);
    segment2.setPositionIndex(22);
    segment3.setPositionIndex(33);

    // create route with segments
    Route route;
    route.appendSegment(segment1);
    route.appendSegment(segment2);
    route.appendSegment(segment3);

    // test segments
    const QList<RouteSegment> &segments = route.segments();
    QVERIFY(segments.count() == 3);
    QCOMPARE(segments.at(0).positionIndex(), 11);
    QCOMPARE(segments.at(1).positionIndex(), 22);
    QCOMPARE(segments.at(2).positionIndex(), 33);
}

void TestRoute::settersAndGetters()
{
    // test data
    QString endPoint = "Kiviharjunlenkki 1";
    QString startPoint = "Kauppurienkatu 21";
    int distance = 2534;
    int time = 212;

    Route route;

    // setters
    route.setEndPointName(endPoint);
    route.setStartPointName(startPoint);
    route.setTotalDistance(distance);
    route.setTotalTime(time);

    // compare values with getters
    QCOMPARE(route.endPointName(), endPoint);
    QCOMPARE(route.startPointName(), startPoint);
    QCOMPARE(route.totalDistance(), distance);
    QCOMPARE(route.totalTime(), time);
}

QTEST_APPLESS_MAIN(TestRoute);

#include "testroute.moc"
