/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

      Katri Kaikkonen - katri.kaikkonen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>
#include <QFrame>
#include <QTextDocument>
#include <QPlainTextEdit>

#include "texteditautoresizer.h"

TextEditAutoResizer::TextEditAutoResizer(QWidget *parent)
    : QObject(parent),
      m_edit(qobject_cast<QFrame *>(parent)),
      m_plainTextEdit(qobject_cast<QPlainTextEdit *>(parent)),
      m_textEdit(qobject_cast<QTextEdit *>(parent))
{
     //parent must either inherit QPlainTextEdit or  QTextEdit!
    Q_ASSERT(m_plainTextEdit || m_textEdit);

    connect(parent, SIGNAL(textChanged()), this, SLOT(textEditChanged()));
    connect(parent, SIGNAL(cursorPositionChanged()), this, SLOT(textEditChanged()));
}

void TextEditAutoResizer::textEditChanged()
{
    qDebug() << __PRETTY_FUNCTION__;
    QTextDocument *document = m_textEdit ? m_textEdit->document() : m_plainTextEdit->document();
    QRect cursor = m_textEdit ? m_textEdit->cursorRect() : m_plainTextEdit->cursorRect();

    QSize size = document->size().toSize();
    if (m_plainTextEdit)
        size.setHeight((size.height() + 1) * m_edit->fontMetrics().lineSpacing());

    const QRect frameRect = m_edit->frameRect();
    const QRect contentsRect = m_edit->contentsRect();

    m_edit->setMinimumHeight(qMax(70, size.height() + (frameRect.height()
                                                       - contentsRect.height() - 1)));

    // make sure the cursor is visible in case we have a QAbstractScrollArea parent
    QPoint position = m_edit->pos();
    QWidget *parentWidget = m_edit->parentWidget();
    while (parentWidget) {
    #ifdef Q_WS_MAEMO_5
        if (parentWidget->parentWidget()) {
            if (QAbstractScrollArea *area = qobject_cast<QAbstractScrollArea *>(
                    parentWidget->parentWidget()->parentWidget())) {
                 if (QAbstractKineticScroller * scroller=
                        area->property("kineticScroller").value<QAbstractKineticScroller *>()) {
                            scroller->ensureVisible(position + cursor.center(), 10 + cursor.width(),
                                 2 * cursor.height());
                }
                break;
        }
    }
    #endif
    position = parentWidget->mapToParent(position);
    parentWidget = parentWidget->parentWidget();
    }
}
