/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef LOCATIONHISTORYLISTVIEW_H
#define LOCATIONHISTORYLISTVIEW_H

#include "listview.h"

/**
* @brief Shows search histroy in list view.
*
* @author Jussi Laitinen - jussi.laitinen (at) ixonos.com
*/
class SearchHistoryListView : public ListView
{
    Q_OBJECT

public:
    /**
    * @brief Constructor.
    *
    * @param parent QWidget
    */
    SearchHistoryListView(QWidget *parent = 0);

public slots:
    /**
    * @brief Slot for list item clicked.
    *
    * @param item ListItem
    * @return true if item was selected, false otherwise
    */
    bool listItemClicked(ListItem *item);

signals:
    /**
    * @brief Signal is emitted when search history item is clicked.
    *
    * @param searchString search string used
    */
    void searchHistoryItemClicked(const QString &searchString);
};

#endif // LOCATIONHISTORYLISTVIEW_H
