/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef SEARCHHISTORYLISTITEM_H
#define SEARCHHISTORYLISTITEM_H

#include <QDateTime>

#include "extendedlistitem.h"

/**
* @brief List item stores information about search history.
*
* @author Jussi Laitinen - jussi.laitinen (at) ixonos.com
*/
class SearchHistoryListItem : public ExtendedListItem
{
public:
    /**
    * @brief Constructor.
    *
    * Sets sub items' text width.
    */
    SearchHistoryListItem();

    /**
    * @brief Destructor.
    */
    ~SearchHistoryListItem();

/******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
public:
    /**
    * @brief Returns date and time.
    *
    * @return QDateTime
    */
    QDateTime dateTime() const;

    /**
    * @brief Sets search history data for this item.
    *
    * @param searchString search string
    * @param dateTime date and time for search
    */
    void setSearchHistoryData(const QString &searchString, const QDateTime &dateTime);

private:
    /**
    * @brief Sets date and time.
    *
    * @param dateTime QDateTime date and time
    */
    void setDateTime(const QDateTime &dateTime);

/******************************************************************************
* DATA MEMBERS
******************************************************************************/
private:
    QDateTime m_dateTime;   ///< Date time
};

#endif // LOCATIONLISTITEM_H
