/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QMouseEvent>
#include <QPainter>
#include <QRect>

#include "panelcommon.h"
#include "paneltab.h"

const int TAB_HEIGHT = 66;
const int TAB_WIDTH_ACTIVE = PANEL_TAB_BAR_WIDTH;

PanelTab::PanelTab(QWidget *parent)
    : QToolButton(parent),
      m_tabActive(false),
      m_tabSelected(false)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_tabActiveImage.load(":/res/images/tab_active.png");
    m_tabInactiveImage.load(":/res/images/tab_inactive.png");
    m_tabInactiveImage2.load(":/res/images/tab_inactive2.png");

    setCheckable(true);

    setFixedSize(TAB_WIDTH_ACTIVE, TAB_HEIGHT);
}

void PanelTab::mouseMoveEvent(QMouseEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (m_tabSelected) {
        if (!rect().contains(event->pos()))
            setDown(false);
        else
            setDown(true);
    }
}

void PanelTab::mousePressEvent(QMouseEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (event->button() == Qt::LeftButton) {
        setDown(true);
        m_tabSelected = true;
    }
}

void PanelTab::mouseReleaseEvent(QMouseEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (event->button() == Qt::LeftButton) {
        if (rect().contains(event->pos())) {
            click();

            if (isChecked())
                setChecked(false);
            else
                setChecked(true);
        }

        setDown(false);
        m_tabSelected = false;
    }
}

void PanelTab::paintEvent(QPaintEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    Q_UNUSED(event);

    const int TAB_WIDTH = 66;
    const int TAB_RECT_X = 0;
    const int TAB_RECT_Y = 0;

    QPainter painter(this);

    if (isChecked()) {
        m_tabRect.setRect(TAB_RECT_X, TAB_RECT_Y, TAB_WIDTH_ACTIVE, TAB_HEIGHT);
        painter.drawPixmap(m_tabRect, m_tabActiveImage);
    } else {
        m_tabRect.setRect(TAB_WIDTH_ACTIVE - TAB_WIDTH, TAB_RECT_Y, TAB_WIDTH, TAB_HEIGHT);
        painter.drawPixmap(m_tabRect, m_tabInactiveImage);
    }

    if (isDown())
        icon().paint(&painter, m_tabRect, Qt::AlignCenter, QIcon::Selected);
    else if (!isEnabled())
        icon().paint(&painter, m_tabRect, Qt::AlignCenter, QIcon::Disabled);
    else
        icon().paint(&painter, m_tabRect, Qt::AlignCenter, QIcon::Normal);
}
