/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef PANELCONTEXTBUTTONBAR_H
#define PANELCONTEXTBUTTONBAR_H

#include <QWidget>

class QState;

/**
 * @brief Base class for panel context button bar
 *
 * @author Pekka Nissinen - pekka.nissinen (at) ixonos.com
 */
class PanelContextButtonBar : public QWidget
{
    Q_OBJECT

public:
    /**
     * @brief Constructor
     *
     * @param parent Parent
     */
    PanelContextButtonBar(QWidget *parent = 0);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
protected:
    /**
     * @brief Draws the bar
     *
     * @param event Paint event
     */
    void paintEvent(QPaintEvent *event);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
     * @brief Hides the context button bar
     */
    void hideContextButtonBar();

    /**
     * @brief Returns the current state of the context button bar
     *
     * @return Current state
     */
    bool isBarVisible() const;

    /**
     * @brief Moves the context button bar to desired position
     *
     * @param x Horizontal position
     * @param y Vertical position
     */
    void move(int x, int y);

    /**
     * @brief Sets the context buttons to the context button bar
     *
     * @param contextButtons Pointer to context buttons
     */
    void setContextButtons(QWidget *contextButtons);

    /**
     * @brief Shows the context button bar
     */
    void showContextButtonBar();

private slots:
    /**
     * @brief Internal slot used to set the context button bar state
     */
    void contextButtonBarStateChanged();

/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
signals:
    /**
     * @brief Signal that is sent when context button bar is hidden
     */
    void barHidden();

    /**
     * @brief Signal that is sent when context button bar is visible
     */
    void barVisible();

    /**
     * @brief This signal is called when context button bar needs to be repositioned
     */
    void positionChangeRequested();

    /**
     * @brief Signal that is sent when the context button bar state must be changed
     */
    void toggleState();

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    bool m_visible;             ///< Current state of the context button bar

    QPixmap m_barTile;          ///< Pixmap for button bar
    QPixmap m_barTop;           ///< Pixmap for button bar top

    QRect m_barRect;            ///< Rect for the button bar

    QState *m_stateHidden;      ///< State of the hidden context button bar
    QState *m_stateVisible;     ///< State of the visible context button bar

    QWidget *m_contextButtons;  ///< Widget for context buttons
};

#endif // PANELCONTEXTBUTTONBAR_H
