/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com
        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QPainter>

#include "panelcommon.h"

#include "panelcontentstack.h"

PanelContentStack::PanelContentStack(QWidget *parent)
    : QStackedWidget(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    const QColor SEMI_TRANSPARENT_BLACK(0, 0, 0, 128);

    resize(PANEL_WIDTH, PANEL_HEIGHT);

    m_menuDropShadowTile.load(":res/images/menu_bar_drop_shadow.png");

    QPalette pal = palette();
    pal.setColor(QPalette::Background, SEMI_TRANSPARENT_BLACK);
    setPalette(pal);
    setAutoFillBackground(true);
}

void PanelContentStack::paintEvent(QPaintEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    Q_UNUSED(event);

    const int SHADOW_RECT_X = 0;
    const int SHADOW_RECT_Y = 0;

    QPainter painter(this);
    QRect shadowRect = QRect(SHADOW_RECT_X, SHADOW_RECT_Y,
                             rect().width(), m_menuDropShadowTile.height());
    painter.drawTiledPixmap(shadowRect, m_menuDropShadowTile);
}

void PanelContentStack::resizeContentStack(const QSize &size)
{
    qDebug() << __PRETTY_FUNCTION__;

    resize(PANEL_WIDTH, size.height() - PANEL_TOP_PADDING - PANEL_BOTTOM_PADDING);
}
