/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com
        Katri Kaikkonen - katri.kaikkonen@ixonos.com
        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef PANELCOMMON_H
#define PANELCOMMON_H

#include <QString>

#include "common.h"

// Dragging settings
const int DRAG_INIT_TIME = 1000;        ///< How long buttons must be pressed to start drag mode
const int FORCE_RELEASE_TIME = 10000;   ///< How long mouse can be grabbed

// Common panel settings
const int MAEMO5_SCROLLBAR_WIDTH = 8; ///< Width of the Maemo scrollbar

const int PANEL_TOP_PADDING = 0;    ///< Amount of padding in top of panels
const int PANEL_BOTTOM_PADDING = 0; ///< Amount of padding in bottom of panels

const int PANEL_BAR_WIDTH = 5;                                              ///< Width of the slider bar
const int PANEL_TAB_BAR_WIDTH = 74;                                         ///< Panel tab bar total width
const int PANEL_BAR_TABBED_WIDTH = PANEL_BAR_WIDTH + PANEL_TAB_BAR_WIDTH;   ///< Width of the tabbed bar
const int PANEL_WIDTH  = 384;                                               ///< Width of the panel contents area
const int PANEL_HEIGHT = DEFAULT_SCREEN_HEIGHT - PANEL_TOP_PADDING
                         - PANEL_BOTTOM_PADDING;                            ///< Height of the panel

const int PANEL_MARGIN_LEFT = MAEMO5_SCROLLBAR_WIDTH; ///< Panel inner margin (left)
const int PANEL_MARGIN_RIGHT = 0;                     ///< Panel inner margin (right)
const int PANEL_MARGIN_TOP = 0;                       ///< Panel inner margin (top)
const int PANEL_MARGIN_BOTTOM = 0;                    ///< Panel inner margin (bottom)

const int PANEL_CLOSED_X = DEFAULT_SCREEN_WIDTH - PANEL_TAB_BAR_WIDTH
                                 - PANEL_BAR_WIDTH; ///< Horizontal position of a closed panel

const int PANEL_OPENED_X = DEFAULT_SCREEN_WIDTH - PANEL_TAB_BAR_WIDTH - PANEL_BAR_WIDTH
                                 - PANEL_WIDTH;     ///< Horizontal position of a open panel

// Zoom button panel settings
const int ZOOM_BUTTON_PANEL_POSITION_X = 10; ///< Horizontal position of zoom panel
const int ZOOM_BUTTON_PANEL_POSITION_Y = 10; ///< Vertical position of zoom panel
const int ZOOM_BUTTON_PANEL_BUTTON_SPACING = 4; ///< Size of a zoom button spacing

const QString ZOOMPANEL_POSITION = "Zoom_Panel_Position";

#endif // PANELCOMMON_H
