/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Pekka Nissinen - pekka.nissinen@ixonos.com
        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef PANELBASE_H
#define PANELBASE_H

#include <QWidget>

class QHBoxLayout;
class QListWidgetItem;
class QVBoxLayout;

class ImageButton;

/**
 * @brief Base class for panels
 *
 * @author Pekka Nissinen - pekka.nissinen (at) ixonos.com
 * @author Sami Rämö - sami.ramo (at) ixonos.com
 */
class PanelBase : public QWidget
{
    Q_OBJECT

public:
    /**
     * @brief Constructor
     *
     * @param parent Parent
     */
    PanelBase(QWidget *parent = 0);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
     * @brief Getter for the generic panel related context buttons
     *
     * @returns Pointer to context buttons widget
     */
    QWidget* genericPanelButtons() const;

    /**
     * @brief Getter for the list item related context buttons
     *
     * @returns Pointer to context buttons widget
     */
    QWidget* itemButtons() const;

protected slots:
    /**
     * @brief Call when there is a change in list item selection
     *
     * Emits listItemSelectionChanged(bool). Parameter is true if any item is selected.
     */
    void onListItemSelectionChanged();

/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
signals:
    /**
     * @brief Signal for requesting a panel to be opened
     *
     * @param widget Pointer to the widget that emitted the signal
     */
    void openPanelRequested(QWidget *widget);

    /**
     * @brief Emitted when there is a change in list item selection
     *
     * @param itemIsSelected True if any item is selected.
     */
    void listItemSelectionChanged(bool itemIsSelected);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
protected:
    QVBoxLayout *m_genericButtonsLayout;    ///< Layout for generic context buttons
    QHBoxLayout *m_itemButtonsLayout;       ///< Layout for item related context buttons

private:
    QWidget *m_genericButtons;              ///< Widget for generic context buttons
    QWidget *m_itemButtons;                 ///< Widget for item related context buttons
};
#endif // PANELBASE_H
