/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Pekka Nissinen - pekka.nissinen@ixonos.com
        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QListWidget>
#include <QResizeEvent>
#include <QVBoxLayout>

#include "panelbase.h"

PanelBase::PanelBase(QWidget *parent)
    : QWidget(parent)
{
    qDebug() << __PRETTY_FUNCTION__;


    // --- GENERIC BUTTONS ---
    m_genericButtons = new QWidget;
    m_genericButtonsLayout = new QVBoxLayout;

    const int CONTEXT_BUTTON_MARGIN_LEFT = 2;
    const int CONTEXT_BUTTON_MARGIN_TOP = 10;
    const int CONTEXT_BUTTON_MARGIN_RIGHT = 0;
    const int CONTEXT_BUTTON_MARGIN_BOTTOM = 0;
    const int CONTEXT_BUTTON_SPACING = 0;
    m_genericButtonsLayout->setContentsMargins(CONTEXT_BUTTON_MARGIN_LEFT,
                                               CONTEXT_BUTTON_MARGIN_TOP,
                                               CONTEXT_BUTTON_MARGIN_RIGHT,
                                               CONTEXT_BUTTON_MARGIN_BOTTOM);
    m_genericButtonsLayout->setSpacing(CONTEXT_BUTTON_SPACING);

    m_genericButtons->setLayout(m_genericButtonsLayout);

    // --- ITEM RELATED BUTTONS ---
    m_itemButtons = new QWidget(this);
    m_itemButtonsLayout = new QHBoxLayout;

    const int ITEM_CONTEXT_BUTTON_MARGIN_BOTTOM = 6;
    const int ITEM_CONTEXT_BUTTON_MARGIN_LEFT = 6;
    const int ITEM_CONTEXT_BUTTON_MARGIN_RIGHT = 6;
    const int ITEM_CONTEXT_BUTTON_MARGIN_TOP = 0;
    const int ITEM_CONTEXT_BUTTON_SPACING = 0;
    m_itemButtonsLayout->setContentsMargins(ITEM_CONTEXT_BUTTON_MARGIN_LEFT,
                                            ITEM_CONTEXT_BUTTON_MARGIN_TOP,
                                            ITEM_CONTEXT_BUTTON_MARGIN_RIGHT,
                                            ITEM_CONTEXT_BUTTON_MARGIN_BOTTOM);
    m_itemButtonsLayout->setSpacing(ITEM_CONTEXT_BUTTON_SPACING);

    m_itemButtons->setLayout(m_itemButtonsLayout);
}

QWidget* PanelBase::genericPanelButtons() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_genericButtons;
}

QWidget* PanelBase::itemButtons() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_itemButtons;
}

void PanelBase::onListItemSelectionChanged()
{
    qDebug() << __PRETTY_FUNCTION__;

    QListWidget *listWidget = dynamic_cast<QListWidget *>(sender());
    if (listWidget && (listWidget->selectedItems().count() > 0))
        emit listItemSelectionChanged(true);
    else
        emit listItemSelectionChanged(false);
}
