/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com
        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QPainter>

#include "panelbar.h"

#include "panelcommon.h"

const int PANEL_BAR_RECT_X = 0;
const int PANEL_BAR_RECT_Y = 0;

PanelBar::PanelBar(QWidget *parent)
    : QWidget(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_barTile.load(":/res/images/panel_bar_tile.png");
    m_menuDropShadowTile.load(":/res/images/menu_bar_drop_shadow.png");
    m_barRect.setRect(PANEL_BAR_RECT_X, PANEL_BAR_RECT_Y, PANEL_BAR_WIDTH, PANEL_HEIGHT);

    resize(PANEL_BAR_WIDTH, PANEL_HEIGHT);
}

void PanelBar::paintEvent(QPaintEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    Q_UNUSED(event);

    const int MENU_DROP_SHADOW_RECT_X = 0;
    const int MENU_DROP_SHADOW_RECT_Y = 0;

    QPainter painter(this);

    painter.drawTiledPixmap(m_barRect, m_barTile);
    painter.drawTiledPixmap(MENU_DROP_SHADOW_RECT_X, MENU_DROP_SHADOW_RECT_Y, PANEL_BAR_WIDTH,
                            m_menuDropShadowTile.height(), m_menuDropShadowTile);
}

void PanelBar::resizeBar(const QSize &size)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_barRect.setRect(PANEL_BAR_RECT_X, PANEL_BAR_RECT_Y, PANEL_BAR_WIDTH, size.height());

    resize(PANEL_BAR_WIDTH, size.height() - PANEL_TOP_PADDING - PANEL_BOTTOM_PADDING);
}
