#include "ossoabookdialog.h"
#include <QDebug>

OssoABookDialog::OssoABookDialog(QObject *parent) :
    QObject(parent)
{
    qDebug() << __PRETTY_FUNCTION__;
}

void OssoABookDialog::showContactDialog(const QString &id)
{
    qDebug() << __PRETTY_FUNCTION__;

    OssoABookContact *contact = OssoABookDialog::lookup(id);
    if (contact) {
        GtkWidget *contactDialog = osso_abook_touch_contact_starter_dialog_new(NULL,
        (OssoABookTouchContactStarter*)osso_abook_touch_contact_starter_new_with_contact(NULL,
        contact));

    gtk_widget_show_all(contactDialog);
    gtk_dialog_run(GTK_DIALOG(contactDialog));
    gtk_widget_destroy(contactDialog);
    }
}

OssoABookContact* OssoABookDialog::lookup(const QString& id)
{
    qDebug() << __PRETTY_FUNCTION__;

    GList* l = NULL; // Do not free
    GError *error = NULL;
    OssoABookAggregator* aggregator = NULL; // Do not free

    aggregator = (OssoABookAggregator*) osso_abook_aggregator_get_default(&error);
    if (error) {
        qWarning() << "error opening addressbook" << error->message;
        g_error_free (error);
        return NULL;
    }

    l = osso_abook_aggregator_lookup(aggregator,qPrintable(id));

    return (OssoABookContact*) l->data;
}
