#include <QDebug>

#include "../common.h"
#include "listcommon.h"

#include "locationlistitem.h"

const int LOCATION_SUBITEM_TEXT_MAX_WIDTH = SUBITEM_TEXT_MAX_WIDTH + MARGIN + IMAGE_WIDTH;

LocationListItem::LocationListItem()
{
    qDebug() << __PRETTY_FUNCTION__;

    setSubitemTextWidth(LOCATION_SUBITEM_TEXT_MAX_WIDTH);
}

void LocationListItem::bounds(GeoCoordinate &swBound, GeoCoordinate &neBound)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_location.viewport(swBound, neBound);
}

GeoCoordinate LocationListItem::coordinates() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_location.coordinates();
}

void LocationListItem::setLocationData(const Location &location)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_location = location;

    QStringList addressComponents = m_location.addressComponents();

    if (addressComponents.isEmpty())
        return;

    setTitle(shortenText(addressComponents.at(0), ITEM_WIDTH - 3 * MARGIN,
                            ListItem::TEXT_SIZE_NORMAL));

    addressComponents.removeFirst();

    if (!addressComponents.isEmpty()) {
        clearSubItems();
        addSubItem(addressComponents.join(", "), QPixmap(":/res/images/compass.png"));
    }

}

LocationListItem::~LocationListItem()
{
    qDebug() << __PRETTY_FUNCTION__;
}
