/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef LISTCOMMON_H
#define LISTCOMMON_H

#include <Qt>

const int ITEM_WIDTH = 368;     ///< Item minimum width
const int ICON_HEIGHT = 24;     ///< Icon height
const int ICON_MARGIN = 2;      ///< Icon margin
const int ICON_WIDTH = 24;      ///< Icon width
const int IMAGE_HEIGHT = 64;    ///< Friend image height
const int IMAGE_WIDTH = 64;     ///< Friend image width
const int ITEM_MIN_HEIGHT = 70; ///< Minimum height for item
const int MARGIN = 5;           ///< Text and image margin

/**
* @var NAME_TEXT_MAX_WIDTH
*
* @brief Name label's maximum width
*/
const int NAME_TEXT_MAX_WIDTH = ITEM_WIDTH - 3 * MARGIN - IMAGE_WIDTH;

/**
* @var SUBITEM_TEXT_MAX_WIDTH
*
* @brief All label's maximum width
*/
const int SUBITEM_TEXT_MAX_WIDTH = ITEM_WIDTH - 3 * MARGIN - IMAGE_WIDTH - MARGIN - ICON_WIDTH
                                   - MARGIN * 2;

const int SUBITEM_TEXT_ROW_HEIGHT = 21;     ///< Subitems text row height

const int TITLE_DISPLAY_INDEX = Qt::DisplayRole;
const int AVATAR_IMAGE_INDEX = Qt::DecorationRole;

const int ITEM_SIZE_HINT_INDEX = Qt::SizeHintRole;
const int DISTANCE_SIZE_HINT_INDEX = Qt::SizeHintRole + 1;


const int SUBITEM_STORE_INDEX = Qt::UserRole;
const int ITEM_EXPANDED_INDEX = Qt::UserRole + 1;
const int ITEM_HAS_IMAGE_INDEX = Qt::UserRole + 2;
const int DISTANCE_TEXT_DISPLAY_INDEX = Qt::UserRole + 3;
const int DISTANCE_IMAGE_INDEX = Qt::UserRole + 4;

#endif // LISTCOMMON_H
