/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Pekka Nissinen - pekka.nissinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef IMAGEBUTTON_H
#define IMAGEBUTTON_H

#include <QPushButton>

/**
 * @brief A simple class for icon button
 *
 * @author Pekka Nissinen - pekka.nissinen (at) ixonos.com
 */
class ImageButton : public QPushButton
{
    Q_OBJECT

public:
    /**
     * @brief Constructor
     *
     * @param normalIconPictureFileName Normal state icon image file name
     * @param selectedIconPictureFileName Selected state icon image file name (optional)
     * @param disabledIconPictureFileName Disabled state icon image file name (optional)
     * @param parent Parent
     */
    ImageButton(const QString &normalIconPictureFileName = QString(),
                const QString &selectedIconPictureFileName = QString(),
                const QString &disabledIconPictureFileName = QString(), QWidget *parent = 0);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
protected:
    /**
     * @brief Event handler for paint events
     *
     * Paints the button and its icon
     * @param event Paint event
     */
    void paintEvent(QPaintEvent *event);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
     * @brief Set button icon.
     *
     * @param image image pixmap
     */
    void setButtonIcon(const QPixmap &image);

private:
    /**
     * @brief Initializes the button by setting graphics and alpha mask
     *
     * @param size Size of the button icon
     * @param icon Image icon
     */
    void initButton(const QSize &size, const QIcon &icon);
};

#endif // IMAGEBUTTON_H
