/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef FRIENDLISTITEM_H
#define FRIENDLISTITEM_H

#include "coordinates/geocoordinate.h"
#include "extendedlistitem.h"

class User;

/**
* @brief List item stores information about friends.
*
* @author Jussi Laitinen - jussi.laitinen (at) ixonos.com
*/
class FriendListItem : public ExtendedListItem
{

public:
    /**
    * @brief Constructor.
    *
    * Sets sub items' text width.
    */
    FriendListItem();

    /**
    * @brief Destructor.
    */
    ~FriendListItem();

/******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
public:
    /**
    * @brief Returns item's coordinates.
    *
    * @return item's coordinates
    */
    GeoCoordinate coordinates() const;

    /**
    * @brief Return's item's Facebook ID
    *
    * @return item's Facebook ID
    */
    QString facebookId() const;

    /**
    * @brief Sets avatar image for this item.
    *
    * @param image image
    */
    void setAvatarImage(const QPixmap &image);

    /**
    * @brief Sets item's coordinates.
    *
    * @param coordinates GeoCoordinate
    */
    void setCoordinates(const GeoCoordinate &coordinates);

    /**
    * @brief Set user data for this item.
    *
    * @param user User pointer
    */
    void setUserData(User *user);

private:
    /**
    * @brief Set distance icon.
    *
    * Icon is selected by distance.
    *
    * @param value distance value
    * @param unit distance unit
    */
    void setDistanceIcon(double value, const QString &unit);

    /**
    * @brief Sets item's Facebook ID
    *
    * @param facebookId item's Facebook ID
    */
    void setFacebookId(const QString &facebookId);

/******************************************************************************
* DATA MEMBERS
******************************************************************************/
private:
    QString m_facebookId;           ///< User's Facebook ID

    GeoCoordinate m_coordinates;    ///< User coordinates
};

#endif // FRIENDLISTITEM_H
