/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

      Henri Lampela - henri.lampela@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QPixmap>

#include "error.h"
#include "network/networkaccessmanager.h"

#include "imagefetcher.h"

ImageFetcher::ImageFetcher(NetworkAccessManager *manager, QObject *parent)
    : QObject(parent)
    , m_manager(manager)
{
    qDebug() << __PRETTY_FUNCTION__;

    connect(m_manager, SIGNAL(finished(QNetworkReply*)), this, SLOT(
            downloadFinished(QNetworkReply*)));
}

void ImageFetcher::fetchImage(const QUrl &url)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_downloadQueue.enqueue(url);

    startNextDownload();
}

void ImageFetcher::startNextDownload()
{
    qDebug() << __PRETTY_FUNCTION__;

    QUrl url = m_downloadQueue.dequeue();

    QNetworkRequest request(url);
    request.setAttribute(QNetworkRequest::CacheSaveControlAttribute, false);
    request.setRawHeader("User-Agent", "Situare");
    QNetworkReply *reply = m_manager->get(request);

    m_currentDownloads.append(reply);
}

void ImageFetcher::downloadFinished(QNetworkReply *reply)
{
    qDebug() << __PRETTY_FUNCTION__;

    //Reply from Facebook
    if (m_currentDownloads.contains(reply)) {

        if (reply->error() == QNetworkReply::NoError) {
            QPixmap image;
            QUrl url = reply->url();

            if (!image.loadFromData(reply->readAll(), 0))
                image = QPixmap();

            emit imageReceived(url, image);
        }
        else {
            emit error(ErrorContext::SITUARE, SituareError::IMAGE_DOWNLOAD_FAILED);
        }

        m_currentDownloads.removeAll(reply);
        reply->deleteLater();

        if (!m_downloadQueue.isEmpty())
            startNextDownload();
    }
}
