/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

      Henri Lampela - henri.lampela@ixonos.com
      Sami Rämö - sami.ramo@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef LOCATION_H
#define LOCATION_H

#include <QString>

#include "coordinates/geocoordinate.h"

/**
 * @brief Container for a single location search result
 *
 * Contains all data for a single location search result item.
 *
 * @author Henri Lampela - henri.lampela@ixonos.com
 * @author Sami Rämö - sami.ramo@ixonos.com
 */
class Location
{
public:

    /**
    * @brief Constructor
    *
    * Constructs empty Location object.
    */
    Location();

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
    /**
    * @brief Gets the address components of the location
    *
    * @returns list of address components
    */
    QStringList addressComponents() const;

    /**
    * @brief Gets the coordinates of the location
    *
    * @returns coordinates of the location
    */
    const GeoCoordinate& coordinates() const;

    /**
    * @brief Gets the formatted address of the location
    *        e.g. Oxford street 1, London W1, United kingdom
    *
    * @returns coordinates of the location
    */
    const QString& formattedAddress() const;

    /**
    * @brief Sets the coordinates of the location
    *
    * @param coordinate Coordinates of the location
    */
    void setCoordinates(const GeoCoordinate &coordinate);

    /**
    * @brief Sets the formatted address of the location
    *
    */
    void setFormattedAddress(const QString &formattedAddress);

    /**
    * @brief Set recommended viewport corner coordinates
    *
    * @param southwest Coordinates of the southwest corner
    * @param northeast Coordinates of the northeast corner
    */
    void setViewPort(const GeoCoordinate &southwest, const GeoCoordinate &northeast);

    /**
    * @brief Gets the coordinates of the recommended viewport of the location
    *
    * @param[out] southwest returns southwest corner coordinates of the recommended viewport
    * @param[out] northeast returns northeast corner coordinates of the recommended viewport
    */
    void viewport(GeoCoordinate &southwest, GeoCoordinate &northeast) const;

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    QString m_formattedAddress;     ///< Placeholder for formatted address

    GeoCoordinate m_coordinates;    ///< Placeholcer for coordinates
    GeoCoordinate m_viewportNE;     ///< Placeholder for viewport northeast corner
    GeoCoordinate m_viewportSW;     ///< Placeholder for viewport southwest corner
};

#endif // LOCATION_H
