/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef MAPROUTEITEM_H
#define MAPROUTEITEM_H

#include <QGraphicsItemGroup>

class Route;

/**
 * @brief Graphics item for map route (a.k.a track)
 *
 * Class is derived from QGraphicsItemGroup and is used as a container for QGraphicsLineItem items
 * which are created between Route geometry points.
 *
 * @author Sami Rämö - sami.ramo@ixonos.com
 */
class MapRouteItem : public QGraphicsItemGroup
{
public:
    /**
    * @brief Constructor
    *
    * @param parent Parent QGraphicsItem
    */
    explicit MapRouteItem(QGraphicsItem *parent = 0);

    /**
    * @brief Constructor with building the route lines
    *
    * @param route Route information used for building the lines presenting a track
    * @param parent Parent QGraphicsItem
    */
    explicit MapRouteItem(Route *route, QGraphicsItem *parent = 0);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
    * @brief Clear the route
    *
    * Deletes all line items.
    */
    void clear();

    /**
    * @brief Set route
    *
    * Does clear old route before setting the new one. Does create lines presenting a track.
    *
    * @param route Route information used for building the lines presenting a track
    */
    void setRoute(Route *route);
};

#endif // MAPROUTEITEM_H
