/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/


#ifndef FRIENDGROUPITEM_H
#define FRIENDGROUPITEM_H

#include <QList>

#include "baselocationitem.h"

class FriendLocationItem;

/**
  * @brief Friend group map item
  *
  * Contains grouped FriendLocationItem items and draws group image with number of grouped friends
  *
  * @author Sami Rämö - sami.ramo@ixonos.com
  */
class FriendGroupItem : public BaseLocationItem
{
    Q_OBJECT

public:
    /**
      * @brief Constructor
      *
      * Create new group, set picture and join first FriendLocationItem to the group.
      * Group position is set to be exactly same as item given as parameter.
      *
      * @param item First FriendLocationItem to be joined to new group
      */
    FriendGroupItem(FriendLocationItem *item);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
public:
    /**
      * @brief Paint event
      *
      * Draw amount of joined FriendLocationItem items over the image.
      */
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);

protected:
    /**
    * @brief Mouse move event.
    *
    * Disables m_clickEvent flag if press and release where not
    * in same area.
    *
    * @param event QGraphicsSceneMouseEvent.
    */
    void mouseMoveEvent(QGraphicsSceneMouseEvent *event);

    /**
    * @brief Mouse press event.
    *
    * Sets mouse press position.
    *
    * @param event QGraphicsSceneMouseEvent.
    */
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

    /**
    * @brief Mouse release event.
    *
    * Emits friendGroupItemClicked signal if press and release where
    * in same area.
    *
    * @param event QGraphicsSceneMouseEvent.
    */
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
      * @brief Drop all FriendLocationItem items from the group
      *
      * Dropped items are set to visible again.
      */
    void dropFriends();

    /**
      * @brief Join new FriendLocationItem to this group.
      *
      * Given item is also hidden.
      *
      * @param item FriendLocationItem to be joined
      */
    void joinFriend(FriendLocationItem *item);

/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
signals:
    /**
    * @brief Signal is emitted when l item is clicked.
    *
    * @param userIDs list of friends user IDs in the group
    */
    void locationItemClicked(const QList<QString> &userIDs);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    QList<FriendLocationItem *> m_friends;  ///< List of joined FriendLocationItem items
    QPointF m_mousePressPosition;           ///< Mouse press position
    bool m_clickEvent;                      ///< Mouse click event flag
};

#endif // FRIENDGROUPITEM_H
