/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDateTime>
#include <QDebug>

#include "geopositioninfo.h"
#include "gpscommon.h"
#include "coordinates/geocoordinate.h"

GeoPositionInfo::GeoPositionInfo()
    : m_timestamp(QDateTime()),
      m_coordinate(GeoCoordinate()),
      m_horizontalAccuracy(GPS_ACCURACY_UNDEFINED),
      m_isAccurate(false)
{
    qDebug() << __PRETTY_FUNCTION__;
}

QDateTime GeoPositionInfo::timestamp() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_timestamp;
}

void GeoPositionInfo::setTimestamp(qreal time)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_timestamp = QDateTime::fromTime_t(time);
}

void GeoPositionInfo::setCoordinate(const GeoCoordinate &coordinate)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_coordinate = coordinate;
}

GeoCoordinate GeoPositionInfo::coordinate() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_coordinate;
}

bool GeoPositionInfo::isValid()
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_coordinate.isValid();
}

void GeoPositionInfo::setAccuracy(bool accurate, qreal accuracy)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (accuracy < 0)
        m_horizontalAccuracy = GPS_ACCURACY_UNDEFINED;
    else
        m_horizontalAccuracy = accuracy;

    m_isAccurate = accurate;
}

qreal GeoPositionInfo::accuracy() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_horizontalAccuracy;
}

bool GeoPositionInfo::isAccurate() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_isAccurate;
}
