#ifndef CONTACTMANAGERPRIVATESTUB_H
#define CONTACTMANAGERPRIVATESTUB_H

#include <QObject>

/**
* @brief Manages phone address book contacts.
*
* STUB CLASS.
*/
class ContactManagerPrivate : public QObject
{
    Q_OBJECT
public:
    /**
    * @brief Constructor
    *
    * @param parent QObject
    */
    ContactManagerPrivate(QObject *parent = 0);

/*******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
    /**
    * @brief Returns contact's guid from contact's facebook ID.
    *
    * RETURNS empty QString.
    *
    * @param facebookId contact's facebook ID
    * @return contact guid
    */
    QString contactGuid(const QString &facebookId) const;

    /**
    * @brief Requests contact guids.
    *
    * Guid is a globally unique ID of a contact, which can be used with
    * other datastores.
    *
    * DOES NOTHING.
    */
    void requestContactGuids();
};

#endif // CONTACTMANAGERPRIVATESTUB_H
