#include <QContact>
#include <QContactGuid>
#include <QContactManager>
#include <QContactOnlineAccount>
#include <QDebug>
#include <QHash>
#include <QList>
#include <QStringList>

#include "contactmanager.h"

#include "contactmanagerprivate.h"

QTM_USE_NAMESPACE

ContactManagerPrivate::ContactManagerPrivate(QObject *parent)
    : QObject(parent),
      m_manager(0)
{
    qDebug() << __PRETTY_FUNCTION__;

    const QString MAEMO5_MANAGER_NAME = "maemo5";

    QStringList availableManagers = QContactManager::availableManagers();

    if (availableManagers.contains(MAEMO5_MANAGER_NAME)) {
        QMap<QString, QString> params;
        QString managerUri = QContactManager::buildUri(MAEMO5_MANAGER_NAME, params);
        m_manager = QContactManager::fromUri(managerUri);
    }
}

QString ContactManagerPrivate::parseFacebookId(const QString &accountUri) const
{
    qDebug() << __PRETTY_FUNCTION__;

    const QString FACEBOOK_CHAT_URL = "@chat.facebook.com";
    int facebookChatUrlIndex = accountUri.indexOf(FACEBOOK_CHAT_URL);
    QString facebookId;

    if (facebookChatUrlIndex != -1) {
        facebookId = accountUri.left(facebookChatUrlIndex);
        facebookId.remove("-");
    }

    return facebookId;
}

QString ContactManagerPrivate::contactGuid(const QString &facebookId) const
{
    qDebug() << __PRETTY_FUNCTION__;

    if (!m_manager) {
        qWarning() << "Manager is uninitialized";
        return QString();
    }

    return m_contactGuids.value(facebookId);
}

void ContactManagerPrivate::requestContactGuids()
{
    qDebug() << __PRETTY_FUNCTION__;

    if (!m_manager) {
        qWarning() << "Manager is uninitialized";
        return;
    }

    QHash<QString, QString> contactGuids;

    foreach (QContact contact, m_manager->contacts()) {
        QContactOnlineAccount account = contact.detail(QContactOnlineAccount::DefinitionName);
        QString facebookId = parseFacebookId(account.accountUri());
        QContactGuid contactGuid = contact.detail(QContactGuid::DefinitionName);

        if (!facebookId.isEmpty())
            contactGuids.insert(facebookId, contactGuid.guid());
    }

    m_contactGuids = contactGuids;
}
