/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com
        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QtTest/QtTest>
#include <QtCore>

#include "ui/panelbase.h"
#include "ui/tabbedpanel.h"

class TestTabbedPanel : public QObject
{
    Q_OBJECT

private slots:
    void testPanelToggling();
};

void TestTabbedPanel::testPanelToggling()
{
    TabbedPanel *testTabbedPanel = new TabbedPanel;

    PanelBase *testPanel = new PanelBase;
    testTabbedPanel->addTab(testPanel, QIcon(":/res/images/user_info.png"));

    QSignalSpy closedSpy(testTabbedPanel, SIGNAL(panelClosed()));
    QSignalSpy openedSpy(testTabbedPanel, SIGNAL(panelOpened()));
    QSignalSpy toggleSpy(testTabbedPanel, SIGNAL(toggleState()));

    // Check that everything is initialized properly
    QVERIFY(closedSpy.isValid());
    QCOMPARE(closedSpy.count(), 0);

    QVERIFY(openedSpy.isValid());
    QCOMPARE(openedSpy.count(), 0);

    QVERIFY(toggleSpy.isValid());
    QCOMPARE(toggleSpy.count(), 0);

    // Try to close the panel. As the panel is closed, no signals should be sent.
    testTabbedPanel->closePanel();
    QTest::qWait(1);
    QCOMPARE(closedSpy.count(), 0);
    QCOMPARE(openedSpy.count(), 0);
    QCOMPARE(toggleSpy.count(), 0);
    QTest::qWait(1000);
    QCOMPARE(closedSpy.count(), 0);
    QCOMPARE(openedSpy.count(), 0);
    QCOMPARE(toggleSpy.count(), 0);

    // Now try to open the panel, only toggleState and panelOpened signals should be sent
    testTabbedPanel->openPanel(testPanel);
    QTest::qWait(1);
    QCOMPARE(closedSpy.count(), 0);
    QCOMPARE(openedSpy.count(), 0);
    QCOMPARE(toggleSpy.count(), 1);
    QTest::qWait(1000);
    QCOMPARE(closedSpy.count(), 0);
    QCOMPARE(openedSpy.count(), 1);
    QCOMPARE(toggleSpy.count(), 1);

    // Now try to open the panel again. As the panel is already open, no signals should not be sent.
    testTabbedPanel->openPanel(testPanel);
    QTest::qWait(1);
    QCOMPARE(closedSpy.count(), 0);
    QCOMPARE(openedSpy.count(), 1);
    QCOMPARE(toggleSpy.count(), 1);
    QTest::qWait(1000);
    QCOMPARE(closedSpy.count(), 0);
    QCOMPARE(openedSpy.count(), 1);
    QCOMPARE(toggleSpy.count(), 1);

    //Now try to close the panel, only toggleState and panelClosed signals should be sent
    testTabbedPanel->closePanel();
    QTest::qWait(1);
    QCOMPARE(closedSpy.count(), 0);
    QCOMPARE(openedSpy.count(), 1);
    QCOMPARE(toggleSpy.count(), 1);
    QTest::qWait(1000);
    QCOMPARE(closedSpy.count(), 1);
    QCOMPARE(openedSpy.count(), 1);
    QCOMPARE(toggleSpy.count(), 2);

    delete testPanel;
    delete testTabbedPanel;
}

QTEST_MAIN(TestTabbedPanel)

#include "testtabbedpanel.moc"
