/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Ville Tiensuu - ville.tiensuu@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QtTest/QtTest>
#include <QtCore>
#include "ui/avatarimage.h"

const int FRIEND_IMAGE_WIDTH = 50;
const int FRIEND_IMAGE_HEIGHT = 50;
const int FRAMED_FRIEND_IMAGE_WIDTH = 64;
const int FRAMED_FRIEND_IMAGE_HEIGHT = 64;
const int OWN_IMAGE_NARROW_WIDTH = 39;
const int OWN_IMAGE_NARROW_HEIGHT = 100;
const int OWN_IMAGE_WIDE_WIDTH = 200;
const int OWN_IMAGE_WIDE_HEIGHT = 20;
const int OWN_IMAGE_FRAME_SIZE = 9;
const int OWN_IMAGE_SUPPORTED_WIDTH = 100;
const int OWN_IMAGE_SUPPORTED_HEIGHT = 100;
const int FIXED_OWN_IMAGE_BORDER_HEIGHT = 118;

class TestAvatarImage : public QObject
{
   Q_OBJECT

private slots:
   void testCreate(); // method tests whether the borders are inserted to the image.
                      // test is based on the image size.
};

void TestAvatarImage::testCreate()
{
    // test friend image (always 50x50)
    QPixmap friend50x50(FRIEND_IMAGE_WIDTH, FRIEND_IMAGE_HEIGHT);
    QPixmap framedFriend50x50 = AvatarImage::create(friend50x50, AvatarImage::Small);
    QCOMPARE(framedFriend50x50.width(), FRAMED_FRIEND_IMAGE_WIDTH);
    QCOMPARE(framedFriend50x50.height(), FRAMED_FRIEND_IMAGE_HEIGHT);

    // test narrow own image
    QPixmap ownNarrow(OWN_IMAGE_NARROW_WIDTH, OWN_IMAGE_NARROW_HEIGHT);
    QPixmap unFramedOwnNarrow = AvatarImage::create(ownNarrow, AvatarImage::Large);
    QCOMPARE(unFramedOwnNarrow.width(), OWN_IMAGE_NARROW_WIDTH);
    QCOMPARE(unFramedOwnNarrow.height(), OWN_IMAGE_NARROW_HEIGHT);

    // test wide own image
    QPixmap ownWide(OWN_IMAGE_WIDE_WIDTH, OWN_IMAGE_WIDE_HEIGHT);
    QPixmap unFramedOwnWide = AvatarImage::create(ownWide, AvatarImage::Large);
    QCOMPARE(unFramedOwnWide.width(), OWN_IMAGE_WIDE_WIDTH);
    QCOMPARE(unFramedOwnWide.height(), OWN_IMAGE_WIDE_HEIGHT);

    // test supported size own image
    QPixmap ownSupported(OWN_IMAGE_SUPPORTED_WIDTH, OWN_IMAGE_SUPPORTED_HEIGHT);
    QPixmap framedOwn = AvatarImage::create(ownSupported, AvatarImage::Large);
    QCOMPARE(framedOwn.width(), OWN_IMAGE_SUPPORTED_WIDTH + 2*OWN_IMAGE_FRAME_SIZE);
    QCOMPARE(framedOwn.height(), FIXED_OWN_IMAGE_BORDER_HEIGHT);
}

QTEST_MAIN(TestAvatarImage)
#include "testavatarimage.moc"
