/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QtTest/QtTest>
#include <QDebug>

#include "map/mapscene.h"
#include "map/maptile.h"

class TestMapScene : public QObject
{
    Q_OBJECT
private slots:
    void addMapTile();
};

/**
* @brief Test adding map tiles
*
* Does check that the map tile is found in right coordinates
*/
void TestMapScene::addMapTile()
{
    const int ZOOM_LEVEL_1ST = 18;
    const int ZOOM_LEVEL_2ND = 16;
    const QPoint TILE_INDEX_1ST = QPoint(1, 2);
    const QPoint TILE_INDEX_2ND = QPoint(2, 3);

    MapScene mapScene;

    // First test:
    // Zoom level is 18, so no stretching should occure
    // Top-left corner x = 256, y = 512
    // Bottom-right corner x + 255, y + 255
    mapScene.setZoomLevel(ZOOM_LEVEL_1ST);
    mapScene.addTile(ZOOM_LEVEL_1ST, TILE_INDEX_1ST, QPixmap("maptile.png"), ZOOM_LEVEL_1ST);

    // Check that there is only one item in the scene and take a pointer to it
    QCOMPARE(mapScene.items().count(), 1);
    MapTile *tile = dynamic_cast<MapTile *>(mapScene.items().at(0));
    QVERIFY(tile);

    // Check around top-left and bottom-right corners
    int x = 256;
    int y = 512;
    int s = 255; //side length -1
    QCOMPARE(mapScene.itemAt(x-1, y), (QGraphicsItem *)0);
    QCOMPARE(mapScene.itemAt(x, y-1), (QGraphicsItem *)0);
    QCOMPARE(mapScene.itemAt(x, y), dynamic_cast<QGraphicsItem *>(tile));
    QCOMPARE(mapScene.itemAt(x+s, y+s), dynamic_cast<QGraphicsItem *>(tile));
    QCOMPARE(mapScene.itemAt(x+s+1, y+s), (QGraphicsItem *)0);
    QCOMPARE(mapScene.itemAt(x+s, y+s+1), (QGraphicsItem *)0);

    // Second test:
    // Zoom level is 16, so stretching is also tested
    // Top-left corner x = 2048, y = 3072
    // Bottom-right corner x + 1023, y + 1023
    tile->setZoomLevel(ZOOM_LEVEL_2ND, ZOOM_LEVEL_2ND);
    tile->setTileNumber(TILE_INDEX_2ND);

    // Check around top-left and bottom-right corners
    x = 2048;
    y = 3072;
    s = 1023; //side length -1
    QCOMPARE(mapScene.itemAt(x-1, y), (QGraphicsItem *)0);
    QCOMPARE(mapScene.itemAt(x, y-1), (QGraphicsItem *)0);
    QCOMPARE(mapScene.itemAt(x, y), dynamic_cast<QGraphicsItem *>(tile));
    QCOMPARE(mapScene.itemAt(x+s, y+s), dynamic_cast<QGraphicsItem *>(tile));
    QCOMPARE(mapScene.itemAt(x+s+1, y+s), (QGraphicsItem *)0);
    QCOMPARE(mapScene.itemAt(x+s, y+s+1), (QGraphicsItem *)0);
}

QTEST_MAIN(TestMapScene)
#include "testmapscene.moc"
