/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com
        Katri Kaikkonen - katri.kaikkonen@ixonos.com
        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QScrollArea>
#include <QVBoxLayout>

#include "imagebutton.h"
#include "panelcommon.h"
#include "userinfo.h"

#include "userinfopanel.h"

UserInfoPanel::UserInfoPanel(QWidget *parent)
    : PanelBase(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    QVBoxLayout *userInfoPanelLayout = new QVBoxLayout;
    userInfoPanelLayout->setMargin(0);
    userInfoPanelLayout->setSpacing(0);
    userInfoPanelLayout->setContentsMargins(PANEL_MARGIN_LEFT, PANEL_MARGIN_TOP,
                                            PANEL_MARGIN_RIGHT, PANEL_MARGIN_BOTTOM);
    setLayout(userInfoPanelLayout);

    m_userInfo = new UserInfo(this);

    QWidget *userInfoView = new QWidget(this);
    QVBoxLayout *userInfoViewLayout = new QVBoxLayout(userInfoView);
    userInfoViewLayout->setMargin(0);
    userInfoViewLayout->setSpacing(0);
    userInfoViewLayout->setStretch(0, 0);
    userInfoViewLayout->setSizeConstraint(QLayout::SetFixedSize);
    userInfoViewLayout->addWidget(m_userInfo);

    QScrollArea *userInfoScroll = new QScrollArea();
    userInfoScroll->setWidgetResizable(true);
    userInfoScroll->setWidget(userInfoView);
    userInfoScroll->setAlignment(Qt::AlignVCenter);
    userInfoScroll->viewport()->setAutoFillBackground(false);
    userInfoScroll->widget()->setAutoFillBackground(false);

    userInfoPanelLayout->addWidget(userInfoScroll);

    connect(m_userInfo, SIGNAL(findUser(GeoCoordinate)),
            this, SIGNAL(findUser(GeoCoordinate)));

    connect(m_userInfo,SIGNAL(requestReverseGeo()),
            this, SIGNAL(requestReverseGeo()));

    connect(m_userInfo, SIGNAL(statusUpdate(QString, bool)),
            this, SIGNAL(statusUpdate(QString, bool)));

    connect(m_userInfo, SIGNAL(notificateUpdateFailing(QString, bool)),
             this, SIGNAL(notificateUpdateFailing(QString, bool)));

    connect(this, SIGNAL(reverseGeoReady(QString)),
            m_userInfo, SIGNAL(reverseGeoReady(QString)));

    connect(this, SIGNAL(clearUpdateLocationDialogData()),
            m_userInfo, SLOT(clearUpdateLocationDialogData()));

    connect(this, SIGNAL(collapse()),
            m_userInfo, SLOT(collapse()));

    ImageButton *updateFriendsButton = new ImageButton(":/res/images/refresh.png",
                                                       ":/res/images/refresh_s.png",
                                                       "", this);
    ImageButton *updateStatusMessageButton = new ImageButton(":/res/images/send_position.png",
                                                             ":/res/images/send_position_s.png",
                                                             "", this);

    m_genericButtonsLayout->addWidget(updateFriendsButton);
    m_genericButtonsLayout->addWidget(updateStatusMessageButton);

    connect(updateFriendsButton, SIGNAL(clicked()),
            this, SIGNAL(refreshUserData()));

    connect(updateStatusMessageButton, SIGNAL(clicked()),
            m_userInfo, SLOT(messageUpdate()));

}

void UserInfoPanel::showUserInfo(bool logged)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_userInfo->setVisible(logged);
}

void UserInfoPanel::userDataReceived(User *user)
{
    qDebug() << __PRETTY_FUNCTION__;

    if(user) {
        m_userInfo->setUserName(user->name());
        m_userInfo->setProfileImage(user->profileImage());
        m_userInfo->setMessageText(user->note());
        m_userInfo->setAddress(user->address());
        m_userInfo->setTime(user->timestamp());
        m_userInfo->setCoordinates(user->coordinates());

        m_userInfo->show();
    }
}
