/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Katri Kaikkonen - katri.kaikkonen@ixonos.com
       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef TEXTMODIFIER_H
#define TEXTMODIFIER_H

#include <QObject>

class QFontMetrics;

/**
* @brief Contains helper methods to modify text.
*/
class TextModifier : public QObject
{
    Q_OBJECT
public:
    /**
    * @brief Shortens text to fit.
    *
    * Text shortening is defined by text maximum width.
    *
    * @param fontMetrics font metrics to use
    * @param text text to shorten
    * @param textMaxWidth maximum width for text
    */
    static QString shortenText(const QFontMetrics fontMetrics, const QString &text,
                               int textMaxWidth);

    /**
     * @brief Splits too long word.
     *
     * Splits long word to several by adding extra spaces
     *
     * @param fontMetrics font metrics to use
     * @param word long word to be splitted
     * @param textMaxWidth maximum width for word
     * @returns splitted word
     */
    static QString splitWord(const QFontMetrics fontMetrics, const QString &word, int textMaxWidth);

    /**
     * @brief Splits long words from text.
     *
     * Splits long words to several by adding extra spaces
     *
     * @param fontMetrics font metrics to use
     * @param text text to be splitted
     * @param textMaxWidth maximum width for word
     * @returns text with long words splitted
     */
    static QString splitLongWords(const QFontMetrics fontMetrics, const QString &text,
                                  int textMaxWidth);
};

#endif // TEXTMODIFIER_H
