/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Katri Kaikkonen - katri.kaikkonen@ixonos.com
       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>
#include <QFontMetrics>
#include <QStringList>

#include "textmodifier.h"

QString TextModifier::shortenText(const QFontMetrics fontMetrics, const QString &text,
                                  int textMaxWidth)
{
    qDebug() << __PRETTY_FUNCTION__;

    QString copiedText = text;
    int index = copiedText.indexOf('\n');

    if (index >= 0) {
        copiedText.truncate(index);
        copiedText.append("...");
    }

    return fontMetrics.elidedText(copiedText, Qt::ElideRight, textMaxWidth);
}

QString TextModifier::splitWord(const QFontMetrics fontMetrics, const QString &word,
                                int textMaxWidth)
{
    qDebug() << __PRETTY_FUNCTION__;

    QString result;
    QString temp;

    for (int i = 0; i < word.length(); i++) {
        if (fontMetrics.width(temp.append(word.at(i))) > textMaxWidth) {
            result.append(temp.left(temp.length() - 1));
            result.append(" ");
            temp.remove(0, temp.length() - 1);
        }
    }

    result.append(temp);

    return result;
}

QString TextModifier::splitLongWords(const QFontMetrics fontMetrics, const QString &text,
                                     int textMaxWidth)
{
    qDebug() << __PRETTY_FUNCTION__;

    QStringList list;
    list = text.split(' ');

    for (int i = 0; i < list.count(); i++) {
        if (fontMetrics.width(list.at(i)) > textMaxWidth)
            list.replace(i, splitWord(fontMetrics, list.at(i), textMaxWidth));
    }

    return list.join(" ");
}
