/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef ROUTEWAYPOINTLISTITEM_H
#define ROUTEWAYPOINTLISTITEM_H

#include "coordinates/geocoordinate.h"
#include "routing/routesegment.h"
#include "extendedlistitem.h"

/**
* @brief List item stores information about route waypoints.
*
* @author Jussi Laitinen - jussi.laitinen (at) ixonos.com
*/
class RouteWaypointListItem : public ExtendedListItem
{
public:
    /**
    * @brief Constructor.
    *
    * Sets sub items' text width.
    */
    RouteWaypointListItem();

    /**
    * @brief Destructor.
    */
    ~RouteWaypointListItem();

/******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
public:
    /**
    * @brief Returns item's coordinates.
    *
    * @return item's coordinates
    */
    GeoCoordinate coordinates() const;

    /**
    * @brief Set route waypoint data for this item.
    *
    * @param routeSegment RouteSegment data
    * @param coordinate GeoCoordinate
    */
    void setRouteWaypointData(const RouteSegment &routeSegment,
                              const GeoCoordinate &coordinate);

private:
    /**
    * @brief Sets item's turn type image.
    *
    * @param turnType turn type defined in RouteSegment class.
    */
    void setTurnTypeImage(const QString &turnType);

/******************************************************************************
* DATA MEMBERS
******************************************************************************/
private:
    GeoCoordinate m_coordinates;   ///< Route segment coordinates
};

#endif // ROUTEWAYPOINTLISTITEM_H

