/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef PANELTABBAR_H
#define PANELTABBAR_H

#include <QWidget>

class QButtonGroup;

/**
 * @brief Class for tab bar
 *
 * @author Pekka Nissinen - pekka.nissinen (at) ixonos.com
 */
class PanelTabBar : public QWidget
{
    Q_OBJECT

public:
    /**
     * @brief Constructor
     *
     * @param parent Parent
     */
    PanelTabBar(QWidget *parent = 0);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
     * @brief Adds a tab
     *
     * Adds a tab with icon and returns the index of the inserted tab
     *
     * @param icon Icon of the tab
     */
    int addTab(const QIcon& icon);

    /**
     * @brief Inserts a tab
     *
     * Inserts a tab with icon at the specified index and returns the index of the inserted tab.
     * If index is out of range, the tab is appended.
     *
     * @param index Index of the tab
     * @param icon Icon of the tab
     */
    int insertTab(int index, const QIcon& icon);

    /**
     * @brief Removes a tab
     *
     * Removes a tab at index position
     *
     * @todo: Fix tab drawing order
     *
     * @param index Index of the tab
     */
    void removeTab(int index);

    /**
    * @brief Returns all tabs.
    *
    * @return All tabs
    */
    QButtonGroup * tabs() const;

private:
    /**
     * @brief Initializes and formats tab buttons layout
     */
    void setUpTabLayout();

public slots:
    /**
     * @brief This slot is used to clear tab selections
     */
    void deselectTabs();

    /**
     * @brief This slot selects a tab at given index
     *
     * @param index Index of the tab
     */
    void selectTab(int index);

private slots:
    /**
     * @brief Sets the tab at current index active
     *
     * @param index Index of the tab
     */
    void setCurrentIndex(int index);

/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
signals:
    /**
     * @brief This signal is emitted whenever the current tab changes
     *
     * @param index Index of the new tab
     */
    void currentChanged(int index);

    /**
     * @brief This signal is emitted when tabs are added or removed
     */
    void sizeChangeRequested();

    /**
     * @brief This signal is emitted whenever user wants to close a tab
     *
     * @param index Index of the currently active tab
     */
    void tabCloseRequested(int index);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    int m_activeTab;    ///< Index of a active tab

    QButtonGroup *m_tabButtonGroup; ///< Button groub for tab buttons
};

#endif // PANELTABBAR_H
