/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QButtonGroup>

#include "panelcommon.h"
#include "paneltab.h"

#include "paneltabbar.h"

const int APPEND_INDEX = -1;
const int NO_ACTIVE_TABS = -1;

PanelTabBar::PanelTabBar(QWidget *parent)
    : QWidget(parent),
      m_activeTab(NO_ACTIVE_TABS)
{
    qDebug() << __PRETTY_FUNCTION__;

    setFixedWidth(PANEL_TAB_BAR_WIDTH);

    m_tabButtonGroup = new QButtonGroup(this);

    connect(m_tabButtonGroup, SIGNAL(buttonPressed(int)),
                this, SLOT(setCurrentIndex(int)));
}

int PanelTabBar::addTab(const QIcon& icon)
{
    qDebug() << __PRETTY_FUNCTION__;

    return insertTab(APPEND_INDEX, icon);
}

void PanelTabBar::deselectTabs()
{
    qDebug() << __PRETTY_FUNCTION__;

    m_activeTab = NO_ACTIVE_TABS;

    m_tabButtonGroup->setExclusive(false);
    m_tabButtonGroup->button(m_tabButtonGroup->checkedId())->setChecked(false);
    m_tabButtonGroup->setExclusive(true);
}

int PanelTabBar::insertTab(int index, const QIcon& icon)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (index == APPEND_INDEX)
        m_tabButtonGroup->addButton(new PanelTab(this));
    else
        m_tabButtonGroup->addButton(new PanelTab(this), index);

    m_tabButtonGroup->button(index)->setIcon(icon);

    setUpTabLayout();

    return index;
}

void PanelTabBar::removeTab(int index)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (QAbstractButton *tab = m_tabButtonGroup->button(index)) {
        m_tabButtonGroup->removeButton(tab);
        delete tab;

        setUpTabLayout();
    }
}

void PanelTabBar::selectTab(int index)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (!m_tabButtonGroup->button(index)->isChecked())
        m_tabButtonGroup->button(index)->click();
}

void PanelTabBar::setCurrentIndex(int index)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (m_activeTab == index) {
        m_activeTab = NO_ACTIVE_TABS;
        emit tabCloseRequested(index);
    } else {
        m_activeTab = index;
        emit currentChanged(index);
    }
}

void PanelTabBar::setUpTabLayout()
{
    qDebug() << __PRETTY_FUNCTION__;

    const int TAB_BUTTON_STEPPING = 65;

    QList<QAbstractButton *> tabList = m_tabButtonGroup->buttons();
    int tabBarHeight = 0;
    for (int i = 0; i < tabList.size(); i ++) {
        tabList.at(i)->move(0, i * TAB_BUTTON_STEPPING);
        tabBarHeight += TAB_BUTTON_STEPPING;
    }

    setFixedHeight(tabBarHeight);

    emit sizeChangeRequested();
}

QButtonGroup * PanelTabBar::tabs() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_tabButtonGroup;
}
