/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef PANELTAB_H
#define PANELTAB_H

#include <QToolButton>

class QMouseEvent;

/**
 * @brief Class for tab button
 *
 * @author Pekka Nissinen - pekka.nissinen (at) ixonos.com
 */
class PanelTab : public QToolButton
{
    Q_OBJECT

public:
    /**
     * @brief Constructor
     *
     * @param parent Parent
     */
    PanelTab(QWidget *parent = 0);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
protected:
    /**
     * @brief Move event for the distance indicator button
     *
     * @param event Mouse event
     */
    void mouseMoveEvent(QMouseEvent *event);

    /**
     * @brief Event handler for mouse press events
     *
     * @param event Mouse event
     */
    void mousePressEvent(QMouseEvent *event);

    /**
     * @brief Event handler for mouse release events
     *
     * @param event Mouse event
     */
    void mouseReleaseEvent(QMouseEvent *event);

    /**
     * @brief Draws the tab button
     *
     * @param event Paint event
     */
    void paintEvent(QPaintEvent *event);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    bool m_tabActive;   ///< Boolean used to track whether the tab button is active or not
    bool m_tabSelected; ///< Boolean used to track whether the tab button is selected or not

    QPixmap m_tabActiveImage;    ///< Pixmap for active tab button
    QPixmap m_tabInactiveImage;  ///< Pixmap for inactive tab button
    QPixmap m_tabInactiveImage2; ///< Pixmap for inactive tab button below active tab button

    QRect m_tabRect;        ///< Rect for the tab button
};

#endif // PANELTAB_H
