/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

      Henri Lampela - henri.lampela@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>
#include <QDialogButtonBox>
#include <QFormLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>

#include "logindialog.h"

LoginDialog::LoginDialog(QWidget *parent)
    : QDialog(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    setWindowTitle(tr("Login to Situare with Facebook account"));

    m_emailEdit = new QLineEdit();
    m_passwordEdit = new QLineEdit();
    m_passwordEdit->setEchoMode(QLineEdit::Password);

    QGridLayout *gridLayout = new QGridLayout(this);
    QDialogButtonBox *buttonBox = new QDialogButtonBox(Qt::Vertical);
    QPushButton *connectButton = buttonBox->addButton(QDialogButtonBox::Ok);
    QPushButton *cancelButton = buttonBox->addButton(QDialogButtonBox::Cancel);
    connectButton->setText(tr("Login"));

    QFormLayout *form = new QFormLayout();
    form->addRow(new QLabel(tr("E-mail:")), m_emailEdit);
    form->addRow(new QLabel(tr("Password:")), m_passwordEdit);

    gridLayout->addLayout(form, 0, 0, 2, 1);
    gridLayout->addWidget(buttonBox, 0, 1, 1, 1);

    connect(connectButton, SIGNAL(clicked()),
            this, SLOT(accept()));
    connect(cancelButton, SIGNAL(clicked()),
            this, SLOT(reject()));

    setLayout(gridLayout);
}

void LoginDialog::setEmailField(const QString &email)
{
    qDebug() << __PRETTY_FUNCTION__;
    if(!email.isEmpty()) {
        m_emailEdit->setText(email);
        m_passwordEdit->setFocus(Qt::OtherFocusReason);
    }
}

void LoginDialog::clearTextFields()
{
    qDebug() << __PRETTY_FUNCTION__;

    m_passwordEdit->clearFocus();
    m_emailEdit->setText(""); // clear() method bugging in Qt 4.6, it leaves "dead" cursor
    m_emailEdit->setFocus(Qt::OtherFocusReason);
    m_passwordEdit->setText("");

}

void LoginDialog::userInput(QString &email, QString &password)
{
    qDebug() << __PRETTY_FUNCTION__;

    email = m_emailEdit->text();
    password = m_passwordEdit->text();
}
