/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef LISTITEMDELEGATE_H
#define LISTITEMDELEGATE_H

#include <QStyledItemDelegate>

/**
* @brief Displays ListItem.
*
* Class is used to display ListItem data.
*
* @author Jussi Laitinen - jussi.laitinen (at) ixonos.com
*/
class ListItemDelegate : public QStyledItemDelegate
{
    Q_OBJECT
public:
    /**
    * @brief Constructor.
    *
    * Loads background image pixmaps.
    * @param parent QWidget
    */
    ListItemDelegate(QWidget *parent = 0);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
    /**
    * @brief Draws ListItem data.
    *
    * Draws item's background, image and name.
    * @param painter QPainter
    * @param option QStyleOptionViewItem
    * @param index QModelIndex
    */
    void paint(QPainter *painter, const QStyleOptionViewItem &option,
               const QModelIndex &index) const;

    /**
    * @brief Returns item's size hint.
    *
    * @param option QStyleOptionViewItem
    * @param index QModelIndex
    * @return QSize
    */
    QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const;

/******************************************************************************
* DATA MEMBERS
******************************************************************************/
private:
    QPixmap m_backgroundBottomImage;   ///< Bottom background image
    QPixmap m_backgroundMiddleImage;   ///< Middle background image
    QPixmap m_backgroundTopImage;      ///< Top background image
    QPixmap m_backgroundBottomSelectedImage;   ///< Selected bottom background image
    QPixmap m_backgroundMiddleSelectedImage;   ///< Selected middle background image
    QPixmap m_backgroundTopSelectedImage;      ///< Selected top background image
};

#endif // LISTITEMDELEGATE_H
