/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>
#include <QPainter>

#include "../common.h"
#include "avatarimage.h"
#include "listcommon.h"
#include "listitem.h"

#include "listitemdelegate.h"

const int BACKGROUND_BOTTOM_HEIGHT = 15;    ///< Background image bottom height
const int BACKGROUND_TOP_HEIGHT = 20;       ///< Background image top height
const int NAME_TOP_MARGIN = 40;             ///< Name text top margin

ListItemDelegate::ListItemDelegate(QWidget *parent) :
    QStyledItemDelegate(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_backgroundTopImage.load(":/res/images/list_item_top.png");
    m_backgroundMiddleImage.load(":/res/images/list_item_middle.png");
    m_backgroundBottomImage.load(":/res/images/list_item_bottom.png");
    m_backgroundTopSelectedImage.load(":/res/images/list_item_top_selected.png");
    m_backgroundMiddleSelectedImage.load(":/res/images/list_item_middle_selected.png");
    m_backgroundBottomSelectedImage.load(":/res/images/list_item_bottom_selected.png");
}

void ListItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option,
                        const QModelIndex &index) const
{
    qDebug() << __PRETTY_FUNCTION__;

    QPixmap image = QPixmap(qvariant_cast<QPixmap>(index.data(AVATAR_IMAGE_INDEX)));
    QString name = index.data(TITLE_DISPLAY_INDEX).toString();
    QSize size = index.data(ITEM_SIZE_HINT_INDEX).toSize();
    bool selected = index.data(ITEM_EXPANDED_INDEX).toBool();

    QRect itemRect = option.rect;

    QRect topRect = QRect(itemRect.left(), itemRect.top(), ITEM_WIDTH,
                          BACKGROUND_TOP_HEIGHT);
    QRect middleRect = QRect(itemRect.left(), topRect.bottom(), ITEM_WIDTH,
                             size.height() - BACKGROUND_TOP_HEIGHT
                             - BACKGROUND_BOTTOM_HEIGHT);
    QRect bottomRect = QRect(topRect.left(), middleRect.bottom(), ITEM_WIDTH,
                             BACKGROUND_BOTTOM_HEIGHT);

    if (selected) {
        painter->drawPixmap(topRect, m_backgroundTopSelectedImage);
        painter->drawPixmap(middleRect, m_backgroundMiddleSelectedImage);
        painter->drawPixmap(bottomRect, m_backgroundBottomSelectedImage);
    } else {
        painter->drawPixmap(topRect, m_backgroundTopImage);
        painter->drawPixmap(middleRect, m_backgroundMiddleImage);
        painter->drawPixmap(bottomRect, m_backgroundBottomImage);
    }

    painter->setPen(Qt::white);
    painter->setFont(NOKIA_FONT_NORMAL);

    //Image is set, draw image and text
    if (!image.isNull()) {
        painter->drawPixmap(itemRect.left() + MARGIN * 2, itemRect.top(), image);
        painter->drawText(itemRect.topLeft() + QPoint(MARGIN * 2 + IMAGE_WIDTH + MARGIN,
                                                      NAME_TOP_MARGIN), name);
    }
    //Draw only text
    else {
        painter->drawText(itemRect.topLeft() + QPoint(MARGIN * 3, NAME_TOP_MARGIN), name);
    }
}

QSize ListItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    qDebug() << __PRETTY_FUNCTION__;

    Q_UNUSED(option);

    return index.data(Qt::SizeHintRole).toSize();
}
