/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com
        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef FULLSCREENBUTTON_H
#define FULLSCREENBUTTON_H

#include <QToolButton>

class QTimer;

/**
 * @brief Fullscreen button class
 *
 * @author Kaj Wallin - kaj.wallin (at) ixonos.com
 * @author Pekka Nissinen - pekka.nissinen (at) ixonos.com
 *
 * @class FullScreenButton fullscreenbutton.h "ui/fullscreenbutton.h"
 */
class FullScreenButton : public QToolButton
{
    Q_OBJECT

public:
    /**
     * @brief Constructor
     *
     * @param parent Parent widget
     */
    FullScreenButton(QWidget *parent = 0);

    /**
     * @brief Desctructor
     */
    ~FullScreenButton();

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
protected:
    /**
     * @brief Event handler for paint events
     *
     * Paints the button and its icon
     * @param event Paint event
     */
    void paintEvent(QPaintEvent *event);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public slots:
    /**
    * @brief Invoke the button (if not already visible) and set hiding timer
    */
    void invoke();

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    QColor *m_normalColor;                  ///< Normal background color
    QLinearGradient *m_selectedGradient;    ///< Selected background
    QPainterPath m_backgroundPath;          ///< Item shape path
    QTimer *m_hidingTimer;                  ///< Timer for hiding the button after a delay
};

#endif // FULLSCREENBUTTON_H
