/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef FRIENDLISTITEMDELEGATE_H
#define FRIENDLISTITEMDELEGATE_H

#include "extendedlistitemdelegate.h"

/**
* @brief Displays FriendListItem.
*
* Class is used to display FriendListItem data.
*
* @author Jussi Laitinen - jussi.laitinen (at) ixonos.com
*/
class FriendListItemDelegate : public ExtendedListItemDelegate
{
public:
    /**
    * @brief Constructor.
    *
    * @param parent QWidget
    */
    FriendListItemDelegate(QWidget *parent = 0);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
    /**
    * @brief Draws FriendListItem data.
    *
    * Draws distance text and icon.
    * @param painter QPainter
    * @param option QStyleOptionViewItem
    * @param index QModelIndex
    */
    void paint(QPainter *painter, const QStyleOptionViewItem &option,
               const QModelIndex &index) const;
};

#endif // FRIENDLISTITEMDELEGATE_H
