/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>
#include <QPainter>

#include "friendlistitemdelegate.h"
#include "../common.h"
#include "listcommon.h"

FriendListItemDelegate::FriendListItemDelegate(QWidget *parent)
    : ExtendedListItemDelegate(parent)
{
    qDebug() << __PRETTY_FUNCTION__;
}

void FriendListItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option,
                                   const QModelIndex &index) const
{
    qDebug() << __PRETTY_FUNCTION__;

    ExtendedListItemDelegate::paint(painter, option, index);

    painter->setPen(COLOR_GRAY);
    painter->setFont(NOKIA_FONT_SMALL);

    QString distance = index.data(DISTANCE_TEXT_DISPLAY_INDEX).toString();
    QPixmap distanceIcon = QPixmap(qvariant_cast<QPixmap>(index.data(DISTANCE_IMAGE_INDEX)));

    QRect itemRect = option.rect;

    QPoint distanceIconPoint = QPoint(ITEM_WIDTH - ICON_WIDTH - 3 * MARGIN,
                                      itemRect.top() + MARGIN);

    QRect distanceRect = index.data(DISTANCE_SIZE_HINT_INDEX).toRect();
    distanceRect.translate(ITEM_WIDTH - distanceRect.width() - 2 * MARGIN,
                           itemRect.top() + ICON_HEIGHT + 3 * MARGIN);

    painter->drawPixmap(distanceIconPoint, distanceIcon);
    painter->drawText(distanceRect, Qt::TextSingleLine, distance);
}
