/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QPainter>
#include <QDebug>
#include <QPixmap>

#include "../user/user.h"
#include "../common.h"
#include "listcommon.h"

#include "friendlistitem.h"

FriendListItem::FriendListItem()
{
    qDebug() << __PRETTY_FUNCTION__;

    setSubitemTextWidth(SUBITEM_TEXT_MAX_WIDTH);
}

FriendListItem::~FriendListItem()
{
    qDebug() << __PRETTY_FUNCTION__;
}

GeoCoordinate FriendListItem::coordinates() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_coordinates;
}

QString FriendListItem::facebookId() const
{
    return m_facebookId;
}

void FriendListItem::setAvatarImage(const QPixmap &image)
{
    qDebug() << __PRETTY_FUNCTION__;

    if(!image.isNull())
        setImage(image);
}

void FriendListItem::setCoordinates(const GeoCoordinate &coordinates)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_coordinates = coordinates;
}

void FriendListItem::setDistanceIcon(double value, const QString &unit)
{
    qDebug() << __PRETTY_FUNCTION__;

    const int AEROPLANE_DISTANCE = 5000;///< Aeroplane distance limit for distance icon
    const int CAR_DISTANCE = 500;       ///< Car distance limit for distance icon
    const int WALK_DISTANCE = 5;        ///< Walk distance limit for distance icon

    QPixmap distanceImage;

    if ((unit == "m") || (value < WALK_DISTANCE))
        distanceImage.load(":/res/images/walk_icon_gray.png");
    else if (value < CAR_DISTANCE)
        distanceImage.load(":/res/images/car_icon_gray.png");
    else if (value < AEROPLANE_DISTANCE)
        distanceImage.load(":/res/images/aeroplane_icon_gray.png");
    else
        distanceImage.load(":/res/images/rocket_icon_gray.png");

    setData(DISTANCE_IMAGE_INDEX, distanceImage);
}


void FriendListItem::setFacebookId(const QString &facebookId)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_facebookId = facebookId;
}
void FriendListItem::setUserData(User *user)
{
    qDebug() << __PRETTY_FUNCTION__;

    QString unit;
    double value;
    user->distance(value, unit);
    QString distanceText = QString::number(value) + " " + unit;
    setData(DISTANCE_TEXT_DISPLAY_INDEX, distanceText);
    setDistanceIcon(value, unit);

    setFacebookId(user->userId());

    //Dummy value to get painter font metrics.
    QPixmap p = QPixmap(ICON_WIDTH, ICON_HEIGHT);
    QPainter painter(&p);
    painter.setFont(NOKIA_FONT_SMALL);
    QFontMetrics distanceTextFontMetrics = painter.fontMetrics();
    QRect distanceRect = distanceTextFontMetrics.boundingRect(distanceText);

    setData(DISTANCE_SIZE_HINT_INDEX, distanceRect);
    setTitle(shortenText(user->name(), NAME_TEXT_MAX_WIDTH - distanceRect.width() - MARGIN * 2,
                        ListItem::TEXT_SIZE_NORMAL));
    setCoordinates(user->coordinates());

    if (!user->profileImage().isNull())
        setImage(user->profileImage());

    clearSubItems();

    addSubItem(user->note(), QPixmap(":/res/images/envelope.png"));
    addSubItem(user->address(), QPixmap(":/res/images/compass.png"));
    addSubItem(user->timestamp(), QPixmap(":/res/images/clock.png"));
}
