/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>

#include "extendedlistitemstore.h"

ExtendedListItemStore::ExtendedListItemStore(const QString &text)
    : m_icon(QPixmap()),
      m_textRect(QRect()),
      m_text(text),
      m_shortenedText(QString())
{
    qDebug() << __PRETTY_FUNCTION__;
}

QPixmap ExtendedListItemStore::icon() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_icon;
}

void ExtendedListItemStore::setIcon(const QPixmap &icon)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_icon = icon;
}

void ExtendedListItemStore::setShortenedText(const QString &shortenedText)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_shortenedText = shortenedText;
}

QString ExtendedListItemStore::shortenedText() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_shortenedText;
}

void ExtendedListItemStore::setTextRect(const QRect &textRect)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_textRect = textRect;
}

QString ExtendedListItemStore::text() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_text;
}

QRect ExtendedListItemStore::textRect() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_textRect;
}
