/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/


#ifndef EXTENDEDLISTITEM_H
#define EXTENDEDLISTITEM_H

#include "listitem.h"

class ExtendedListItemStore;

/**
* @brief Base class for extended list items.
*
* @author Jussi Laitinen - jussi.laitinen (at) ixonos.com
*/
class ExtendedListItem : public ListItem
{
public:
    /**
    * @brief Constructor.
    *
    * Sets item size and creates sub item store list.
    */
    ExtendedListItem();

    /**
    * @brief Destructor.
    *
    * Deletes sub item stores and sub item store list.
    */
    virtual ~ExtendedListItem();

/*******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
public:
    /**
    * @brief Adds sub item.
    *
    * Sub item area is defined by sub item text width.
    * @param text sub item text
    * @param icon sub item icon, optional
    */
    void addSubItem(const QString &text, const QPixmap &icon = QPixmap());

    /**
    * @brief Clears sub items.
    *
    * Clears sub items' list and deletes items. Sets item default and
    * extended height to default values.
    */
    void clearSubItems();

    /**
    * @brief Sets item selected.
    *
    * @param selected true if selected, false otherwise
    */
    void setSelected(bool selected);

    /**
    * @brief Sets sub items' text width.
    *
    * @param width sub item width
    */
    void setSubitemTextWidth(int width);

    /**
    * @brief Toggles selection.
    *
    * @return true if selection was toggled, false otherwise
    */
    bool toggleSelection();

private:
    /**
    * @brief Returns text's bounding rect.
    *
    * Takes into account line breaks in text.
    *
    * @param text text which rect is calculated
    */
    QRect boundingRect(const QString &text);

    /**
    * @brief Calculates text rects.
    *
    * Rect width is defined by sub item text width.
    * @param text text which rect is calculated
    * @return text rect
    */
    QRect calculateExpandedTextRect(const QString &text);

/******************************************************************************
* DATA MEMBERS
******************************************************************************/
private:
    bool m_selected;        ///< Selected flag
    int m_expandedHeight;   ///< Item expanded height
    int m_normalHeight;     ///< Item normal height
    int m_subItemTextWidth; ///< Sub items' text wdith

    QList<ExtendedListItemStore *> *m_subItemStoreList; ///< ExtendedListItemStore list
};

#endif // EXTENDEDLISTITEM_H
