# -------------------------------------------------
# Project created by QtCreator 2010-03-26T07:57:35
# -------------------------------------------------
TARGET = ../situare
TEMPLATE = app
INCLUDEPATH += /usr/include/qjson
LIBS += -lqjson
RESOURCES += ../images.qrc \
    ../languages.qrc
TRANSLATIONS += ../res/languages/situare_fi.ts
SOURCES += main.cpp \
    application.cpp \
    coordinates/geocoordinate.cpp \
    coordinates/scenecoordinate.cpp \
    engine/contactmanager.cpp \
    engine/engine.cpp \
    engine/mce.cpp \
    facebookservice/facebookauthentication.cpp \
    facebookservice/facebookcredentials.cpp \
    gps/gpsposition.cpp \
    map/baselocationitem.cpp \
    map/friendgroupitem.cpp \
    map/frienditemshandler.cpp \
    map/friendlocationitem.cpp \
    map/gpslocationitem.cpp \
    map/mapengine.cpp \
    map/mapfetcher.cpp \
    map/maprouteitem.cpp \
    map/mapscene.cpp \
    map/mapscroller.cpp \
    map/maptile.cpp \
    map/maptilerequest.cpp \
    map/mapview.cpp \
    map/ownlocationitem.cpp \
    network/networkaccessmanager.cpp \
    network/networkcookiejar.cpp \
    network/networkhandler.cpp \
    network/networkreply.cpp \
    routing/geocodingservice.cpp \
    routing/location.cpp \
    routing/route.cpp \
    routing/routesegment.cpp \
    routing/routingservice.cpp \
    situareservice/imagefetcher.cpp \
    situareservice/situareservice.cpp \
    ui/updatelocation/texteditautoresizer.cpp \
    ui/updatelocation/updatelocationdialog.cpp \
    ui/avatarimage.cpp \
    ui/extendedlistitem.cpp \
    ui/extendedlistitemdelegate.cpp \
    ui/extendedlistitemstore.cpp \
    ui/friendlistitem.cpp \
    ui/friendlistitemdelegate.cpp \
    ui/friendlistpanel.cpp \
    ui/friendlistview.cpp \
    ui/fullscreenbutton.cpp \
    ui/imagebutton.cpp \
    ui/indicatorbutton.cpp \
    ui/listitem.cpp \
    ui/listitemdelegate.cpp \
    ui/listview.cpp \
    ui/locationlistitem.cpp \
    ui/locationlistview.cpp \
    ui/indicatorbuttonpanel.cpp \
    ui/locationsearchpanel.cpp \
    ui/logindialog.cpp \
    ui/mainwindow.cpp \
    ui/mapscale.cpp \
    ui/panelbar.cpp \
    ui/panelbase.cpp \
    ui/panelcontentstack.cpp \
    ui/panelcontextbuttonbar.cpp \
    ui/paneltab.cpp \
    ui/paneltabbar.cpp \
    ui/routingpanel.cpp \
    ui/routewaypointlistitem.cpp \
    ui/routewaypointlistview.cpp \    
    ui/searchdialog.cpp \
    ui/searchhistorylistitem.cpp \
    ui/searchhistorylistview.cpp \
    ui/settingsdialog.cpp \
    ui/tabbedpanel.cpp \
    ui/textmodifier.cpp \
    ui/userinfo.cpp \
    ui/userinfopanel.cpp \
    ui/zoombutton.cpp \
    ui/zoombuttonpanel.cpp \
    user/user.cpp \
    ui/listitemcontextbuttonbar.cpp
HEADERS += application.h \
    common.h \
    coordinates/geocoordinate.h \
    coordinates/scenecoordinate.h \
    engine/contactmanager.h \
    engine/engine.h \
    engine/mce.h \
    error.h \
    facebookservice/facebookauthentication.h \
    facebookservice/facebookcommon.h \
    facebookservice/facebookcredentials.h \
    gps/gpscommon.h \
    gps/gpsposition.h \
    map/baselocationitem.h \
    map/friendgroupitem.h \
    map/frienditemshandler.h \
    map/friendlocationitem.h \
    map/gpslocationitem.h \
    map/mapcommon.h \
    map/mapengine.h \
    map/mapfetcher.h \
    map/maprouteitem.h \
    map/mapscene.h \
    map/mapscroller.h \
    map/maptile.h \
    map/maptilerequest.h \
    map/mapview.h \
    map/osm.h \
    map/ownlocationitem.h \
    network/networkaccessmanager.h \
    network/networkcookiejar.h \
    network/networkhandler.h \
    network/networkreply.h \
    routing/geocodingservice.h \
    routing/location.h \
    routing/route.h \
    routing/routesegment.h \
    routing/routingcommon.h \    
    routing/routingservice.h \
    situareservice/imagefetcher.h \
    situareservice/situarecommon.h \
    situareservice/situareservice.h \
    ui/updatelocation/texteditautoresizer.h \
    ui/updatelocation/updatelocationdialog.h \
    ui/avatarimage.h \
    ui/extendedlistitem.h \
    ui/extendedlistitemdelegate.h \
    ui/extendedlistitemstore.h \
    ui/friendlistitem.h \
    ui/friendlistitemdelegate.h \
    ui/friendlistpanel.h \
    ui/friendlistview.h \
    ui/fullscreenbutton.h \
    ui/imagebutton.h \
    ui/indicatorbutton.h \
    ui/indicatorbuttonpanel.h \
    ui/listcommon.h \    
    ui/listview.h \
    ui/listitem.h \
    ui/listitemdelegate.h \
    ui/logindialog.h \
    ui/locationlistitem.h \
    ui/locationlistview.h \
    ui/locationsearchpanel.h \
    ui/mainwindow.h \
    ui/mapscale.h \
    ui/panelbar.h \
    ui/panelbase.h \
    ui/panelcommon.h \
    ui/panelcontentstack.h \
    ui/panelcontextbuttonbar.h \
    ui/paneltab.h \
    ui/paneltabbar.h \
    ui/routingpanel.h \
    ui/routewaypointlistitem.h \
    ui/routewaypointlistview.h \
    ui/searchdialog.h \
    ui/searchhistorylistitem.h \
    ui/searchhistorylistview.h \
    ui/settingsdialog.h \
    ui/tabbedpanel.h \
    ui/textmodifier.h \
    ui/userinfo.h \
    ui/userinfopanel.h \
    ui/zoombutton.h \
    ui/zoombuttonpanel.h \
    user/user.h \
    ui/listitemcontextbuttonbar.h
QT += network \
    webkit
DEFINES += QT_NO_DEBUG_OUTPUT

simulator {
    SOURCES += network/networkhandlerprivatestub.cpp \
               gps/gpspositionprivate.cpp
    HEADERS += network/networkhandlerprivatestub.h \
               gps/gpspositionprivate.h
    QT += maemo5
    CONFIG += mobility
    MOBILITY += location
} else:maemo5 {
    armel {
        DEFINES += ARMEL
        INCLUDEPATH += /usr/include/glib-2.0 /usr/lib/glib-2.0/include
        SOURCES += network/networkhandlerprivate.cpp \
                   engine/mceprivate.cpp
        HEADERS += network/networkhandlerprivate.h \
                   engine/mceprivate.h
        QT += dbus xml
        CONFIG += icd2 qdbus
        SOURCES += gps/gpspositionprivateliblocation.cpp \
                   gps/liblocationwrapper.cpp \
                   gps/geopositioninfo.cpp
        HEADERS += gps/gpspositionprivateliblocation.h \
                   gps/liblocationwrapper.h \
                   gps/geopositioninfo.h
        CONFIG += link_pkgconfig
        PKGCONFIG += glib-2.0 liblocation mce gtk+-2.0 libosso-abook-1.0
        LIBS += -llocation
        SOURCES += engine/contactmanagerprivate.cpp \
                   ui/ossoabookdialog.cpp
        HEADERS += engine/contactmanagerprivate.h \
                   ui/ossoabookdialog.h
        CONFIG += mobility
        MOBILITY += contacts
    } else {
        SOURCES += gps/gpspositionprivatestub.cpp \
                   network/networkhandlerprivatestub.cpp \
                   engine/mceprivatestub.cpp
        HEADERS += gps/gpspositionprivatestub.h \
                   network/networkhandlerprivatestub.h \
                   engine/mceprivatestub.h
        SOURCES += engine/contactmanagerprivatestub.cpp
        HEADERS += engine/contactmanagerprivatestub.h
    }

    QT += maemo5

    message([QJson])
    message(Make sure you have QJson development headers installed)
    message(add: deb http://repository.maemo.org/extras-devel fremantle free non-free)
    message(to Scratchbox's sources.list in /etc/apt)
    message(run: apt-get update)
    message(install headers with: apt-get install libqjson-dev)
    message([QtMobility])
    message(Make sure you have QtMobility development headers installed)
    message(install headers with: apt-get install libqtm-dev)
} else {
    SOURCES += gps/gpspositionprivatestub.cpp \
               network/networkhandlerprivatestub.cpp \
               engine/mceprivatestub.cpp
    HEADERS += gps/gpspositionprivatestub.h \
               network/networkhandlerprivatestub.h \
               engine/mceprivatestub.h
    SOURCES += engine/contactmanagerprivatestub.cpp
    HEADERS += engine/contactmanagerprivatestub.h
    message(QJson built in)
    message(Make sure you have QJson development headers installed)
    message(install headers with: sudo apt-get install libqjson-dev)
}

# -----------------------------------------------------------------
# Debian packetizing additions
# -----------------------------------------------------------------
unix {
    # VARIABLES
    isEmpty(PREFIX):PREFIX = /usr
    BINDIR = $$PREFIX/bin
    DATADIR = $$PREFIX/share
    DEFINES += DATADIR=\\\"$$DATADIR\\\" \
        PKGDATADIR=\\\"$$PKGDATADIR\\\"

    # MAKE INSTALL
    desktop.path = $$DATADIR/applications/hildon
    desktop.files += situare.desktop
    INSTALLS += desktop
    icon48.path = $$DATADIR/icons/hicolor/48x48/apps
    icon48.files += ../res/icon/48x48/situare.png
    INSTALLS += icon48
    icon64.path = $$DATADIR/icons/hicolor/64x64/apps
    icon64.files += ../res/icon/64x64/situare.png
    INSTALLS += icon64
    target.path = $$BINDIR
    INSTALLS += target
}
